/*
libhugepagealloc - wrapper malloc for using large pages 
Copyright (C) 2005  Simon Hausmann

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Contact: jan.treibig@informatik.uni-erlangen.de
*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

int main()
{
    const size_t sz = 4 * (1 << 22);
    void *ptr = malloc(sz);
    printf("got page %p\n", ptr);
    memset(ptr, 42, sz);
    free(ptr);
    printf("freed page\n");
    return 0;
}

/* vim: et sw=4 ts=4
 */
