#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <assert.h>
#include <stdlib.h>
#include "dimepack.h"


// forward declaration of test problems
void problem1();
void problem2();
void problem3();
void problem4();
void problem5();
void problem6();
void problem7();
void problem8();
void problem9();

int main(int argc, char **argv)
{

  if(argc!=2){
    cerr << "Usage: " << argv[0] << " <Problem Number>" << endl;
    return -1;
  }
  else{

    int problemNo=atoi(argv[1]);

    if(problemNo==1) problem1();
    else if(problemNo==2) problem2();
    else if(problemNo==3) problem3();
    else if(problemNo==4) problem4();
    else if(problemNo==5) problem5();
    else if(problemNo==6) problem6();
    else if(problemNo==7) problem7();
    else if(problemNo==8) problem8();
    else if(problemNo==9) problem9();
    else exit(0);

    return 0;
  }
}


void problem1()
{
  // ******************
  // * PROBLEM NO. 1: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 1 *******" << endl << endl;
  
  const int nlevels=2;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-12;
  const int maxit=1;
  const int SIZE= 33;
  int i;
  
  const int nxp=SIZE;
  const int nyp=SIZE;
    
  const DIME_REAL hx= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
  
  dpGrid2d u(nxp, nyp, hx, hy);
  u.initzero();
  const bool isInitialized=true;
  
  dpGrid2d f(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      f.setval(x,y)= sin(2.0*M_PI*x*hx)*sin(2.0*M_PI*y*hy);
  
  const int nu1=2;
  const int nu2=2;
  
  // Number of matrix coefficients:
  const int ncoeff=5;
  
  const DIME_REAL hsq = (1.0/(DIME_REAL) (nxp-1))*(1.0/(DIME_REAL) (nxp-1));
  
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
  
  matcoeff[0]= -1.0/hsq;
  matcoeff[1]= -1.0/hsq;
  matcoeff[2]= 4.0/hsq;
  matcoeff[3]= -1.0/hsq;
  matcoeff[4]= -1.0/hsq;
  
  // Specify boundary types
  tBoundary btypes[4];
  for(i=0; i<4; i++)
    {
      btypes[i] = DIRICHLET;
    }
  
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
  
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
    
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 0.0;
      bvals[dpWEST][i]= 0.0;
    }
  
  const tRestrict rtype=FW;
  const DIME_REAL omega= 1.0;
  const bool fixSol=true;

  // Call the DiMEPACK library function:
  dpFMGVcycleConst(nlevels,ntype,epsilon,0,(&u),(&f),nu1,nu2,1,ncoeff,
  		   matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem2()
{

  // ******************
  // * PROBLEM NO. 2: *
  // ******************

  cout << endl << "******* PROBLEM NO. 2 *******" << endl << endl;
  
  const int nlevels=3;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-12;
  const int maxit=5;
  const int SIZE= 33;
  int i;
  
  const int nxp=SIZE;
  const int nyp=SIZE;
    
  const DIME_REAL hx= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
  
  dpGrid2d u(nxp, nyp, hx, hy);
  u.initzero();
  const bool isInitialized=true;
  
  dpGrid2d f(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      f.setval(x,y)= sin(5*M_PI*x*hx)*sin(M_PI*y*hy);
  
  const int nu1=2;
  const int nu2=2;
    
  // Number of matrix coefficients:
  const int ncoeff=9;
    
  const DIME_REAL hsq = (1.0/(DIME_REAL) (nxp-1))*(1.0/(DIME_REAL) (nxp-1));
    
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
  
  matcoeff[0]= -1.0/(6.0*hsq);
  matcoeff[1]= -4.0/(6.0*hsq);
  matcoeff[2]= -1.0/(6.0*hsq);
  matcoeff[3]= -4.0/(6.0*hsq);
  matcoeff[4]= 20.0/(6.0*hsq);
  matcoeff[5]= -4.0/(6.0*hsq);
  matcoeff[6]= -1.0/(6.0*hsq);
  matcoeff[7]= -4.0/(6.0*hsq);
  matcoeff[8]= -1.0/(6.0*hsq);
  
  // Specify boundary types
  tBoundary btypes[4];
  for(i=0; i<4; i++)
    {
      btypes[i] = DIRICHLET;
    }
    
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
  
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
    
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 0.0;
      bvals[dpWEST][i]= 0.0;
    }
    
  const tRestrict rtype=FW;
  const DIME_REAL omega= 1.0;
  const bool fixSol=false;    

  // Call the DiMEPACK library function:
  dpVcycleConst(nlevels,ntype,epsilon,maxit,(&u),isInitialized,(&f),nu1,nu2,ncoeff,
		matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem3()
{
  // ******************
  // * PROBLEM NO. 3: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 3 (4x NEUMANN) *******" << endl << endl;
  
  const int nlevels=6;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-12;
  const int maxit=6;
  const int SIZE=65;
  int i;
    
  const int nxp=SIZE;
  const int nyp=SIZE;
    
  const DIME_REAL hx= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
  
  dpGrid2d u(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      u.setval(x,y)= sin(5*M_PI*x*hx)*sin(M_PI*y*hy);
  const bool isInitialized=true;
    
  dpGrid2d f(nxp, nyp, hx, hy);
  f.initzero();
    
  const int nu1=2;
  const int nu2=2;
    
  // Number of matrix coefficients:
  const int ncoeff=5;
    
  const DIME_REAL hsq = (1.0/(DIME_REAL) (nxp-1))*(1.0/(DIME_REAL) (nxp-1));
    
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
    
  matcoeff[0]= -1.0/hsq;
  matcoeff[1]= -1.0/hsq;
  matcoeff[2]= 4.0/hsq;
  matcoeff[3]= -1.0/hsq;
  matcoeff[4]= -1.0/hsq;

  // Specify boundary types
  tBoundary btypes[4];

  btypes[dpNORTH]= NEUMANN;
  btypes[dpEAST]= NEUMANN;
  btypes[dpSOUTH]= NEUMANN;
  btypes[dpWEST]= NEUMANN;
    
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
  
  for(i=0; i<nxp; i++)
    {
      // bvals[dpNORTH][i]= (1.0/SIZE)*i;
      bvals[dpNORTH][i]= 0.0;
      // bvals[dpSOUTH][i]= (1.0/SIZE)*(SIZE-1-i);
      bvals[dpSOUTH][i]= 0.0;
    }
  
  for(i=0; i<nyp; i++)
    {
      // bvals[dpEAST][i]= (1.0/SIZE)*i;
      bvals[dpEAST][i]= 0.0;
      // bvals[dpWEST][i]= (1.0/SIZE)*(SIZE-1-i);
      bvals[dpWEST][i]= 0.0;
    }
  
  const tRestrict rtype=FW;
  const DIME_REAL omega= 1.0;
  const bool fixSol=true;
    
  // Call the DiMEPACK library function:
  dpVcycleConst(nlevels,ntype,epsilon,maxit,(&u),isInitialized,(&f),nu1,nu2,ncoeff,
		matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem4()
{
  // ******************
  // * PROBLEM NO. 4: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 4 *******" << endl << endl;
  
  const int nlevels=2;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-12;
  const int maxit=1;
  const int SIZE= 33;
  int i;
    
  const int nxp=SIZE;
  const int nyp=(SIZE-1)/2+1;
    
  const DIME_REAL hx= 2.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
    
  cout << "Mesh width hx: " << hx << endl;
  cout << "Mesh width hy: " << hy << endl;

  dpGrid2d u(nxp, nyp, hx, hy);
  u.initzero();
  const bool isInitialized=true;
    
  dpGrid2d f(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      f.setval(x,y)= sin(5*M_PI*x*hx)*sin(M_PI*y*hy);
    
  const int nu1=2;
  const int nu2=2;
    
  // Number of matrix coefficients:
  const int ncoeff=5;
    
  const DIME_REAL hsq = (1.0/(DIME_REAL) (nxp-1))*(1.0/(DIME_REAL) (nxp-1));
  
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
    
  matcoeff[0]= -1.0/hsq;
  matcoeff[1]= -1.0/hsq;
  matcoeff[2]= 4.0/hsq;
  matcoeff[3]= -1.0/hsq;
  matcoeff[4]= -1.0/hsq;
    
  // Specify boundary types
  tBoundary btypes[4];
  for(i=0; i<4; i++)
    {
      btypes[i] = DIRICHLET;
    }
    
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
    
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
  
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 0.0;
      bvals[dpWEST][i]= 0.0;
    }
    
  const tRestrict rtype=FW;
  const DIME_REAL omega= 1.0;
  const bool fixSol=false;
    
  // Call the DiMEPACK library function:
  dpVcycleConst(nlevels,ntype,epsilon,maxit,(&u),isInitialized,(&f),nu1,nu2,ncoeff,
		matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem5()
{
  // ******************
  // * PROBLEM NO. 5: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 5 (FMG) *******" << endl << endl;
  
  const int nlevels=9;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-12;
  const int maxAddIt=0;
  const int gamma= 4;
  const int SIZE= 1025;
  int i;
  
  const int nxp=SIZE;
  const int nyp=SIZE;
    
  const DIME_REAL hx= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
  
  dpGrid2d u(nxp, nyp, hx, hy);
  u.initzero();
  
  dpGrid2d f(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      f.setval(x,y)= 2.0*M_PI*M_PI*sin(M_PI*x*hx)*sin(M_PI*y*hy);
  
  const int nu1=2;
  const int nu2=2;
  
  // Number of matrix coefficients:
  const int ncoeff=5;
  
  const DIME_REAL hsq = hx*hx;
  
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
  
  matcoeff[0]= -1.0/hsq;
  matcoeff[1]= -1.0/hsq;
  matcoeff[2]= 4.0/hsq;
  matcoeff[3]= -1.0/hsq;
  matcoeff[4]= -1.0/hsq;
  
  // Specify boundary types
  tBoundary btypes[4];
  for(i=0; i<4; i++)
    {
      btypes[i] = DIRICHLET;
    }
  
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
  
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
    
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 0.0;
      bvals[dpWEST][i]= 0.0;
    }
  
  const tRestrict rtype=FW;
  const DIME_REAL omega= 1.0;
  const bool fixSol=false;
    
  // Call the DiMEPACK library function:
  dpFMGVcycleConst(nlevels,ntype,epsilon,maxAddIt,(&u),(&f),nu1,nu2,gamma,ncoeff,
		   matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem6()
{
  // ******************
  // * PROBLEM NO. 6: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 6 (FMG) *******" << endl << endl;
  
  const int nlevels=5;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-12;
  const int maxAddIt=0;
  const int gamma= 1;
  const int SIZE= 65;
  int i;
  
  const int nxp=SIZE;
  const int nyp=SIZE;
    
  const DIME_REAL hx= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
  
  dpGrid2d u(nxp, nyp, hx, hy);
  u.initzero();
  
  dpGrid2d f(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      f.setval(x,y)= 2.0*M_PI*M_PI*sin(M_PI*x*hx)*sin(M_PI*y*hy);
  
  const int nu1=2;
  const int nu2=2;
  
  // Number of matrix coefficients:
  const int ncoeff=5;
  
  const DIME_REAL hsq = hx*hx;
  
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
  
  matcoeff[0]= -1.0/hsq;
  matcoeff[1]= -1.0/hsq;
  matcoeff[2]= 4.0/hsq;
  matcoeff[3]= -1.0/hsq;
  matcoeff[4]= -1.0/hsq;
  
  // Specify boundary types
  tBoundary btypes[4];
  btypes[dpNORTH]= DIRICHLET;
  btypes[dpSOUTH]= DIRICHLET;
  btypes[dpEAST]= NEUMANN;
  btypes[dpWEST]= NEUMANN;
  
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
  
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
    
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 10.0-10.0*i*hx;
      bvals[dpWEST][i]= 10.0*i*hx;
    }
  
  const tRestrict rtype=FW;
  const DIME_REAL omega= 1.0;
  const bool fixSol=false;
    
  ofstream outfile_uinit("u-start.dat");
  dpPrintGrid(outfile_uinit, u.getmem(), u.getdimx(), u.getdimy(), u.getpad());

  // Call the DiMEPACK library function:
  dpFMGVcycleConst(nlevels,ntype,epsilon,maxAddIt,(&u),(&f),nu1,nu2,gamma,ncoeff,
  		   matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem7()
{
  // ******************
  // * PROBLEM NO. 7: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 7 (4x NEUMANN) *******" << endl << endl;
  
  const int nlevels=5;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-14;
  const int maxAddIt=2;
  const int gamma= 1;
  const int SIZE= 65;
  int i;
  
  const int nxp=SIZE;
  const int nyp=SIZE;
    
  const DIME_REAL hx= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
  
  dpGrid2d f(nxp, nyp, hx, hy);
  f.initzero();
  
  dpGrid2d u(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      u.setval(x,y)= 2.0*M_PI*M_PI*sin(M_PI*x*hx)*sin(M_PI*y*hy);
  
  const int nu1=2;
  const int nu2=2;
  
  // Number of matrix coefficients:
  const int ncoeff=5;
  
  const DIME_REAL hsq = hx*hx;
  
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
  
  matcoeff[0]= -1.0/hsq;
  matcoeff[1]= -1.0/hsq;
  matcoeff[2]= 4.0/hsq;
  matcoeff[3]= -1.0/hsq;
  matcoeff[4]= -1.0/hsq;
  
  // Specify boundary types
  tBoundary btypes[4];
  for(i=0; i<4; i++)
    {
      btypes[i] = NEUMANN;
    }
  btypes[dpNORTH]= DIRICHLET;
  
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
  
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
    
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 0.0;
      bvals[dpWEST][i]= 0.0;
    }
  
  const tRestrict rtype=FW;
  const DIME_REAL omega= 1.0;
  const bool fixSol=true;
    
  ofstream outfile_uinit("u-start.dat");
  dpPrintGrid(outfile_uinit, u.getmem(), u.getdimx(), u.getdimy(), u.getpad());
  
  // Call the DiMEPACK library function:
  dpFMGVcycleConst(nlevels,ntype,epsilon,maxAddIt,(&u),(&f),nu1,nu2,gamma,ncoeff,
		   matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem8()
{
  // ******************
  // * PROBLEM NO. 8: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 8 *******" << endl << endl;
  
  const int nlevels=2;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=0.0;
  const int maxit=5;
  const int SIZE=129;
  int i;
    
  const int nxp=SIZE;
  const int nyp=SIZE;
  // const int nyp=(SIZE-1)/4+1;
    
  const DIME_REAL hx= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
    
  cout << "Mesh width hx: " << hx << endl;
  cout << "Mesh width hy: " << hy << endl;

  dpGrid2d u(nxp, nyp, hx, hy);
  int x, y;
  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      u.setval(x,y)= sin(5*M_PI*x*hx)*sin(M_PI*y*hy);
  const bool isInitialized=true;
    
  const int nu1=2;
  const int nu2=2;
    
  // Number of matrix coefficients:
  const int ncoeff=5;
    
  const DIME_REAL hxsq = hx*hx;
  const DIME_REAL hysq = hy*hy;
  
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
    
  matcoeff[0]= 1.0/hysq;
  matcoeff[1]= 1.0/hxsq;
  matcoeff[2]= -2.0/hxsq-2.0/hysq;
  matcoeff[3]= 1.0/hxsq;
  matcoeff[4]= 1.0/hysq;
    
  // Specify boundary types
  tBoundary btypes[4];
  for(i=0; i<4; i++)
    {
      btypes[i] = DIRICHLET;
    }
    
  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
    
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
  
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 0.0;
      bvals[dpWEST][i]= 0.0;
    }
    
  const tRestrict rtype=FW;

  // Red-Black Gauss-Seidel smoother:
  cout << "\nGauss-Seidel:" << endl;
  DIME_REAL omega= 1.0;
  const bool fixSol=false;

  dpVcycleConst(nlevels,ntype,epsilon,maxit,(&u),isInitialized,NULL,nu1,nu2,ncoeff,
  		matcoeff,btypes,bvals,rtype,omega,fixSol);

  for (y= 0; y<nyp; y++)
    for (x= 0; x<nxp; x++)
      u.setval(x,y)= sin(5*M_PI*x*hx)*sin(M_PI*y*hy);

  // Optimized (?) red-black SOR smoother:
  cout << "\nSOR:" << endl;
  omega= dpCalcOmega(hx,hy);  

  dpVcycleConst(nlevels,ntype,epsilon,maxit,(&u),isInitialized,NULL,nu1,nu2,ncoeff,
		matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}


void problem9()
{
  // ******************
  // * PROBLEM NO. 9: *
  // ******************
    
  cout << endl << "******* PROBLEM NO. 9 *******" << endl << endl;
  
  const int nlevels=0;
  const tNorm ntype=L2;
  const DIME_REAL epsilon=1e-16;
  const int maxit=5;
  const int SIZE=33;
  int i;
    
  const int nxp= SIZE;
  const int nyp= SIZE;
    
  const DIME_REAL hy= 1.0/(DIME_REAL) (nxp-1);
  const DIME_REAL hx= hy;
  // const DIME_REAL hy= 1.0/(DIME_REAL) (nyp-1);
    
  cout << "Mesh width hx: " << hx << endl;
  cout << "Mesh width hy: " << hy << endl;

  dpGrid2d u(nxp, nyp, hx, hy);
  u.initzero();
  const bool isInitialized=true;
    
  dpGrid2d f(nxp, nyp, hx, hy);
  for (int y= 0; y<nyp; y++)
    for (int x= 0; x<nxp; x++)
      f.setval(x,y)= sin(5*M_PI*x*hx)*sin(M_PI*y*hy);
    
  const int nu1=2;
  const int nu2=2;
    
  // Number of matrix coefficients:
  const int ncoeff=5;
    
  const DIME_REAL hxsq = hx*hx;
  const DIME_REAL hysq = hy*hy;
  
  DIME_REAL *matcoeff=new DIME_REAL[ncoeff];
  assert (matcoeff!=NULL);
    
  matcoeff[0]= -1.0/hysq;
  matcoeff[1]= -1.0/hxsq;
  matcoeff[2]= 2.0/hxsq+2.0/hysq;
  matcoeff[3]= -1.0/hxsq;
  matcoeff[4]= -1.0/hysq;
    
  // Specify boundary types
  tBoundary btypes[4];
  for(i=0; i<4; i++)
    {
      btypes[i] = DIRICHLET;
    }

  // Specify boundary values
  DIME_REAL **bvals=new DIME_REAL*[4];
  bvals[dpNORTH]= new DIME_REAL[nxp];
  bvals[dpSOUTH]= new DIME_REAL[nxp];
  bvals[dpEAST]=  new DIME_REAL[nyp];
  bvals[dpWEST]=  new DIME_REAL[nyp];
    
  for(i=0; i<nxp; i++)
    {
      bvals[dpNORTH][i]= 0.0;
      bvals[dpSOUTH][i]= 0.0;
    }
  
  for(i=0; i<nyp; i++)
    {
      bvals[dpEAST][i]= 0.0;
      bvals[dpWEST][i]= 0.0;
    }
    
  const tRestrict rtype=FW;
  DIME_REAL omega= 1.0;
  const bool fixSol=false;

  dpVcycleConst(nlevels,ntype,epsilon,maxit,(&u),isInitialized,(&f),nu1,nu2,ncoeff,
  		matcoeff,btypes,bvals,rtype,omega,fixSol);

  delete[] bvals[dpNORTH]; 
  delete[] bvals[dpEAST]; 
  delete[] bvals[dpSOUTH]; 
  delete[] bvals[dpWEST]; 
  delete[] bvals;
  delete[] matcoeff;
}
