include(general.m4)

      PROGRAM testrb5p
      IMPLICIT NONE

      INTEGER niter,nxp,nyp,padu,padf
      PARAMETER (niter=2,nxp=33,nyp=33,padu=1,padf=1)

      DIME_REAL checksum

      DIME_REAL coeff(9)
      INTEGER btype(4)
      DIME_REAL u(nxp+padu,nyp)
      DIME_REAL f(nxp+padf,nyp)
      DIME_REAL curcheck
      DIME_REAL check

      INTEGER i

C---------------------------------------------------------
C     Constante coefficients for 5-point stencil codes ---
C---------------------------------------------------------

      print *,"---------------------"
      print *,"-- 5-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.25
      coeff(3)=0.25
      coeff(4)=0.25
      coeff(5)=0.25

C      CALL showu(u,nxp,nyp,padu)

C-----------------------------
C     Dirichlet boundaries ---
C-----------------------------

      print *,"--------------------------"
      print *,"-- Dirichlet boundaries --"
      print *,"--------------------------"

      btype(1)=0
      btype(2)=0
      btype(3)=0
      btype(4)=0


      PRINT *,"Standard..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C---------------------------
C     Neumann boundaries ---
C---------------------------

      print *,"------------------------"
      print *,"-- Neumann boundaries --"
      print *,"------------------------"

      btype(1)=1
      btype(2)=1
      btype(3)=1
      btype(4)=1

      PRINT *,"Standard..."
 
      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C-----------------------------------------
C     Dirichlet and Neumann boundaries ---
C-----------------------------------------

      print *,"---------------------------------------------"
      print *,"-- Dirichlet and Neumann boundaries (NS/EW)--"
      print *,"---------------------------------------------"

      btype(1)=0
      btype(2)=1
      btype(3)=0
      btype(4)=1

      PRINT *,"Standard..."
 
      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C-----------------------------------------
C     Dirichlet and Neumann boundaries ---
C-----------------------------------------

      print *,"---------------------------------------------"
      print *,"-- Dirichlet and Neumann boundaries (EW/NS)--"
      print *,"---------------------------------------------"

      btype(1)=1
      btype(2)=0
      btype(3)=1
      btype(4)=0

      PRINT *,"Standard..."
 
      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn5h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C---------------------------------------------------------
C     Constante coefficients for 9-point stencil codes ---
C---------------------------------------------------------

      print *,"---------------------"
      print *,"-- 9-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.2
      coeff(3)=0.05
      coeff(4)=0.2
      coeff(5)=0.05
      coeff(6)=0.2
      coeff(7)=0.05
      coeff(8)=0.2
      coeff(9)=0.05

C-----------------------------
C     Dirichlet boundaries ---
C-----------------------------

      print *,"--------------------------"
      print *,"-- Dirichlet boundaries --"
      print *,"--------------------------"

      btype(1)=0
      btype(2)=0
      btype(3)=0
      btype(4)=0

      PRINT *,"Standard..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C---------------------------
C     Neumann boundaries ---
C---------------------------

      print *,"------------------------"
      print *,"-- Neumann boundaries --"
      print *,"------------------------"

      btype(1)=1
      btype(2)=1
      btype(3)=1
      btype(4)=1

      PRINT *,"Standard..."
 
      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C-----------------------------------------
C     Dirichlet and Neumann boundaries ---
C-----------------------------------------

      print *,"----------------------------------------------"
      print *,"-- Dirichlet and Neumann boundaries (NS/EW) --"
      print *,"----------------------------------------------"

      btype(1)=0
      btype(2)=1
      btype(3)=0
      btype(4)=1

      PRINT *,"Standard..."
 
      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C-----------------------------------------
C     Dirichlet and Neumann boundaries ---
C-----------------------------------------

      print *,"----------------------------------------------"
      print *,"-- Dirichlet and Neumann boundaries (EW/NS) --"
      print *,"----------------------------------------------"

      btype(1)=1
      btype(2)=0
      btype(3)=1
      btype(4)=0

      PRINT *,"Standard..."
 
      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h1(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h2(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h3(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9c4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgh9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL ssn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      CALL init(u,f,nxp,nyp,padu,padf)
      CALL sgn9h4(nxp,nyp,u,padu,f,padf,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C------------------
C test finished ---
C------------------

      END

C--------------------------
C     utilitiy routines ---
C--------------------------

      SUBROUTINE init(u,f,nxp,nyp,padu,padf)
      INTEGER nxp,nyp,padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      INTEGER i,j
C
      DO j=0,nyp-1
        DO i=0,nxp+padu-1
          u(i,j)=0.0 
        ENDDO
      ENDDO
      DO j=0,nyp-1
        DO i=0,nxp+padf-1
          f(i,j)=0.0 
        ENDDO
      ENDDO
      DO i=0,nxp-1
        u(i,nyp-1)=(1.0/nxp)*i
        u(i,0)=(1.0/nxp)*(nxp-1-i)
      ENDDO
      DO i=0,nyp-1
        u(nxp-1,i)=(1.0/nyp)*i
        u(0,i)=(1.0/nyp)*(nyp-1-i)
      ENDDO
      END

      DIME_REAL FUNCTION checksum(u,nxp,nyp,padu)
      IMPLICIT NONE
      INTEGER padu,nxp,nyp
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL c
      INTEGER i,j
C
      c=0.0
      DO j=0,nyp-1
        DO i=0,nxp-1
          c=c+u(i,j)
        ENDDO
      ENDDO
C
      checksum=c
      RETURN
      END

      SUBROUTINE showu(u,nxp,nyp,padu)
      IMPLICIT NONE
      INTEGER nxp,nyp,padu
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      INTEGER i,j
C
      DO j=0,nyp-1
        DO i=0,nxp-1
          PRINT *,i,j,u(i,j)
        ENDDO
        PRINT *
      ENDDO
      END
