C#
C# Comments:
C# -----------------------------------------------------------
C# - ce, no, ne, ea, se, so, sw, we, and nw are the coefficients
C#   from the coeff array (computed by the calling routine)
C#
C# -----------------------------------------------------------
C#

C# s: SOR smoother omega!=1
C# h: homogeneous equation f==0
C# 5: 5 point stencil
C# c: constant coefficients
define(`relax_s_h_5_c',`r=ce*u($1,$2)+so*u($1,$2-1)+
     &      no*u($1,$2+1)+ea*u($1+1,$2)+we*u($1-1,$2)
	u($1,$2)=r')
define(`relax_no_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_ne_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_se_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+(no+so)*u($1,$2+1)+
     &      (we+ea)*u($1-1,$2)')
define(`relax_so_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+(no+so)*u($1,$2+1)+
     &      ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_sw_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+(no+so)*u($1,$2+1)+
     &      (ea+we)*u($1+1,$2)')
define(`relax_we_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(ea+we)*u($1+1,$2)')
define(`relax_nw_boundary_s_h_5_c',`u($1,$2)=ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# g: standard Gauss-Seidel smoother omega==1
C# h: homogeneous equation f==0
C# 5: 5 point stencil
C# c: constant coefficients
define(`relax_g_h_5_c',`u($1,$2)=no*u($1,$2+1)+
     &      so*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_no_boundary_g_h_5_c',`u($1,$2)=
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_ne_boundary_g_h_5_c',`u($1,$2)=
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_g_h_5_c',`u($1,$2)=no*u($1,$2+1)+
     &      so*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_se_boundary_g_h_5_c',`u($1,$2)=(no+so)*u($1,$2+1)+
     &      (we+ea)*u($1-1,$2)')
define(`relax_so_boundary_g_h_5_c',`u($1,$2)=(no+so)*u($1,$2+1)+
     &      ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_sw_boundary_g_h_5_c',`u($1,$2)=(no+so)*u($1,$2+1)+
     &      (ea+we)*u($1+1,$2)')
define(`relax_we_boundary_g_h_5_c',`u($1,$2)=no*u($1,$2+1)+
     &      so*u($1,$2-1)+(ea+we)*u($1+1,$2)')
define(`relax_nw_boundary_g_h_5_c',`u($1,$2)=
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# s: SOR smoother omega!=1
C# n: non-homogeneous equation f!=0
C# 5: 5 point stencil
C# c: constant coefficients
define(`relax_s_n_5_c',`r=f($1,$2)+ce*u($1,$2)+so*u($1,$2-1)+
     &      no*u($1,$2+1)+ea*u($1+1,$2)+we*u($1-1,$2)
	u($1,$2)=r')
define(`relax_no_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_ne_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_se_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(no+so)*u($1,$2+1)+
     &      (we+ea)*u($1-1,$2)')
define(`relax_so_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(no+so)*u($1,$2+1)+
     &      ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_sw_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(no+so)*u($1,$2+1)+
     &      (ea+we)*u($1+1,$2)')
define(`relax_we_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(ea+we)*u($1+1,$2)')
define(`relax_nw_boundary_s_n_5_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# g: standard Gauss-Seidel smoother omega==1
C# n: non-homogeneous equation f!=0
C# 5: 5 point stencil
C# c: constant coefficients
define(`relax_g_n_5_c',`u($1,$2)=f($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_no_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_ne_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_se_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+(no+so)*u($1,$2+1)+
     &      (we+ea)*u($1-1,$2)')
define(`relax_so_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+(no+so)*u($1,$2+1)+
     &      ea*u($1+1,$2)+we*u($1-1,$2)')
define(`relax_sw_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+(no+so)*u($1,$2+1)+
     &      (ea+we)*u($1+1,$2)')
define(`relax_we_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(ea+we)*u($1+1,$2)')
define(`relax_nw_boundary_g_n_5_c',`u($1,$2)=f($1,$2)+
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# s: SOR smoother omega!=1
C# h: homogeneous equation f==0
C# 5: 5 point stencil
C# h: constant coefficients and no,ea,so, and we coefficients are equal
define(`relax_s_h_5_h',`u($1,$2)=ce*u($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+u($1+1,$2)+u($1-1,$2))')
define(`relax_no_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+no*(
     &      2*u($1,$2-1)+u($1+1,$2)+u($1-1,$2))')
define(`relax_ne_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+no*(
     &      2*u($1,$2-1)+2*u($1-1,$2))')
define(`relax_ea_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1-1,$2))')
define(`relax_se_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+2*no*(u($1,$2+1)+
     &      u($1-1,$2))')
define(`relax_so_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+no*(2*u($1,$2+1)+
     &      u($1+1,$2)+u($1-1,$2))')
define(`relax_sw_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+2*no*(u($1,$2+1)+
     &      u($1+1,$2))')
define(`relax_we_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1+1,$2))')
define(`relax_nw_boundary_s_h_5_h',`u($1,$2)=ce*u($1,$2)+2*no*(
     &      u($1,$2-1)+u($1+1,$2))')

C# g: standard Gauss-Seidel smoother omega==1
C# h: homogeneous equation f==0
C# 5: 5 point stencil
C# h: constant coefficients and no,ea,so, and we coefficients are equal
define(`relax_g_h_5_h',`u($1,$2)=no*(u($1,$2+1)+
     &      u($1,$2-1)+u($1+1,$2)+u($1-1,$2))')
define(`relax_no_boundary_g_h_5_h',`u($1,$2)=no*(
     &      2*u($1,$2-1)+u($1+1,$2)+u($1-1,$2))')
define(`relax_ne_boundary_g_h_5_h',`u($1,$2)=no*(
     &      2*u($1,$2-1)+2*u($1-1,$2))')
define(`relax_ea_boundary_g_h_5_h',`u($1,$2)=no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1-1,$2))')
define(`relax_se_boundary_g_h_5_h',`u($1,$2)=2*no*(u($1,$2+1)+
     &      u($1-1,$2))')
define(`relax_so_boundary_g_h_5_h',`u($1,$2)=no*(2*u($1,$2+1)+
     &      u($1+1,$2)+u($1-1,$2))')
define(`relax_sw_boundary_g_h_5_h',`u($1,$2)=2*no*(u($1,$2+1)+
     &      u($1+1,$2))')
define(`relax_we_boundary_g_h_5_h',`u($1,$2)=no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1+1,$2))')
define(`relax_nw_boundary_g_h_5_h',`u($1,$2)=2*no*(
     &      u($1,$2-1)+u($1+1,$2))')

C# s: SOR smoother omega!=1
C# n: non-homogeneous equation f!=0
C# 5: 5 point stencil
C# h: constant coefficients and no,ea,so, and we coefficients are equal
define(`relax_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+u($1+1,$2)+u($1-1,$2))')
define(`relax_no_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*(
     &      2*u($1,$2-1)+u($1+1,$2)+u($1-1,$2))')
define(`relax_ne_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*(
     &      2*u($1,$2-1)+2*u($1-1,$2))')
define(`relax_ea_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1-1,$2))')
define(`relax_se_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+2*no*(u($1,$2+1)+
     &      u($1-1,$2))')
define(`relax_so_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*(2*u($1,$2+1)+
     &      u($1+1,$2)+u($1-1,$2))')
define(`relax_sw_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+2*no*(u($1,$2+1)+
     &      u($1+1,$2))')
define(`relax_we_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1+1,$2))')
define(`relax_nw_boundary_s_n_5_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+2*no*(
     &      u($1,$2-1)+u($1+1,$2))')

C# g: standard Gauss-Seidel smoother omega==1
C# n: non-homogeneous equation f!=0
C# 5: 5 point stencil
C# h: constant coefficients and no,ea,so, and we coefficients are equal
define(`relax_g_n_5_h',`r=f($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+u($1+1,$2)+u($1-1,$2))
	u($1,$2)=r')
define(`relax_no_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+no*(
     &      2*u($1,$2-1)+u($1+1,$2)+u($1-1,$2))')
define(`relax_ne_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+no*(
     &      2*u($1,$2-1)+2*u($1-1,$2))')
define(`relax_ea_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1-1,$2))')
define(`relax_se_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+2*no*(u($1,$2+1)+
     &      u($1-1,$2))')
define(`relax_so_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+no*(2*u($1,$2+1)+
     &      u($1+1,$2)+u($1-1,$2))')
define(`relax_sw_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+2*no*(u($1,$2+1)+
     &      u($1+1,$2))')
define(`relax_we_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1+1,$2))')
define(`relax_nw_boundary_g_n_5_h',`u($1,$2)=f($1,$2)+2*no*(
     &      u($1,$2-1)+u($1+1,$2))')

C#--------------------
C# 9 point stencil ---
C#--------------------

C# s: SOR smoother omega!=1
C# h: homogeneous equation f==0
C# 9: 9 point stencil
C# c: constant coefficients
define(`relax_s_h_9_c',`u($1,$2)=ce*u($1,$2)+
     &      no*u($1,$2+1)+so*u($1,$2-1)+ea*u($1+1,$2)+
     &      we*u($1-1,$2)+ne*u($1+1,$2+1)+
     &      se*u($1+1,$2-1)+nw*u($1-1,$2+1)+sw*u($1-1,$2-1)')
define(`relax_no_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+
     &      we*u($1-1,$2)+
     &      (se+ne)*u($1+1,$2-1)+(sw+nw)*u($1-1,$2-1)')
define(`relax_ne_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2-1)+
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+
     &      no*u($1,$2+1)+so*u($1,$2-1)+
     &      (we+ea)*u($1-1,$2)+
     &      (sw+se)*u($1-1,$2-1)+(nw+ne)*u($1-1,$2+1)')
define(`relax_se_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2+1)+
     &      (no+so)*u($1,$2+1)+(we+ea)*u($1-1,$2)')
define(`relax_so_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+
     &      (no+so)*u($1,$2+1)+ea*u($1+1,$2)+
     &      we*u($1-1,$2)+(ne+se)*u($1+1,$2+1)+
     &      (nw+sw)*u($1-1,$2+1)')
define(`relax_sw_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2+1)+
     &      (no+so)*u($1,$2+1)+(ea+we)*u($1+1,$2)')
define(`relax_we_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+
     &      no*u($1,$2+1)+so*u($1,$2-1)+(ea+we)*u($1+1,$2)+
     &      (ne+nw)*u($1+1,$2+1)+
     &      (se+sw)*u($1+1,$2-1)')
define(`relax_nw_boundary_s_h_9_c',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2-1)+
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# g: standard Gauss-Seidel smoother omega==1
C# h: homogeneous equation f==0
C# 9: 9 point stencil
C# c: constant coefficients
define(`relax_g_h_9_c',`u($1,$2)=no*u($1,$2+1)+
     &      so*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)+
     &      ne*u($1+1,$2+1)+se*u($1+1,$2-1)+
     &      nw*u($1-1,$2+1)+sw*u($1-1,$2-1)')
define(`relax_no_boundary_g_h_9_c',`u($1,$2)=
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)+
     &      (se+ne)*u($1+1,$2-1)+
     &      (sw+nw)*u($1-1,$2-1)')
define(`relax_ne_boundary_g_h_9_c',`u($1,$2)=(nw+ne+sw+se)*u($1-1,$2-1)+
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_g_h_9_c',`u($1,$2)=no*u($1,$2+1)+
     &      so*u($1,$2-1)+(we+ea)*u($1-1,$2)+
     &      (nw+ne)*u($1-1,$2+1)+(sw+se)*u($1-1,$2-1)')
define(`relax_se_boundary_g_h_9_c',`u($1,$2)=(no+so)*u($1,$2+1)+(nw+ne+sw+se)*u($1-1,$2+1)+
     &      (we+ea)*u($1-1,$2)')
define(`relax_so_boundary_g_h_9_c',`u($1,$2)=(no+so)*u($1,$2+1)+
     &      ea*u($1+1,$2)+we*u($1-1,$2)+
     &      (ne+se)*u($1+1,$2+1)+
     &      (nw+sw)*u($1-1,$2+1)')
define(`relax_sw_boundary_g_h_9_c',`u($1,$2)=(no+so)*u($1,$2+1)+(nw+ne+sw+se)*u($1+1,$2+1)+
     &      (ea+we)*u($1+1,$2)')
define(`relax_we_boundary_g_h_9_c',`u($1,$2)=no*u($1,$2+1)+
     &      so*u($1,$2-1)+(ea+we)*u($1+1,$2)+
     &      (ne+nw)*u($1+1,$2+1)+(se+sw)*u($1+1,$2-1)')
define(`relax_nw_boundary_g_h_9_c',`u($1,$2)=(nw+ne+sw+se)*u($1+1,$2-1)+
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# s: SOR smoother omega!=1
C# n: non-homogeneous equation f!=0
C# 9: 9 point stencil
C# c: constant coefficients
define(`relax_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*u($1,$2+1)+so*u($1,$2-1)+ea*u($1+1,$2)+
     &      we*u($1-1,$2)+ne*u($1+1,$2+1)+
     &      se*u($1+1,$2-1)+nw*u($1-1,$2+1)+
     &      sw*u($1-1,$2-1)')
define(`relax_no_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)+
     &      (se+ne)*u($1+1,$2-1)+(sw+nw)*u($1-1,$2-1)')
define(`relax_ne_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2-1)+
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*u($1,$2+1)+so*u($1,$2-1)+
     &      (we+ea)*u($1-1,$2)+
     &      (nw+ne)*u($1-1,$2+1)+(sw+se)*u($1-1,$2-1)')
define(`relax_se_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2+1)+
     &      (no+so)*u($1,$2+1)+(we+ea)*u($1-1,$2)')
define(`relax_so_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      (no+so)*u($1,$2+1)+ea*u($1+1,$2)+
     &      we*u($1-1,$2)+(ne+se)*u($1+1,$2+1)+
     &      (nw+sw)*u($1-1,$2+1)')
define(`relax_sw_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2+1)+
     &      (no+so)*u($1,$2+1)+(ea+we)*u($1+1,$2)')
define(`relax_we_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*u($1,$2+1)+so*u($1,$2-1)+(ea+we)*u($1+1,$2)+
     &      (ne+nw)*u($1+1,$2+1)+(se+sw)*u($1+1,$2-1)')
define(`relax_nw_boundary_s_n_9_c',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2-1)+
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# g: standard Gauss-Seidel smoother omega==1
C# n: non-homogeneous equation f!=0
C# 9: 9 point stencil
C# c: constant coefficients
define(`relax_g_n_9_c',`u($1,$2)=f($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)+
     &      ne*u($1+1,$2+1)+se*u($1+1,$2-1)+
     &      nw*u($1-1,$2+1)+sw*u($1-1,$2-1)')
define(`relax_no_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+
     &      (so+no)*u($1,$2-1)+ea*u($1+1,$2)+we*u($1-1,$2)+
     &      (se+ne)*u($1+1,$2-1)+(sw+nw)*u($1-1,$2-1)')
define(`relax_ne_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+(nw+ne+sw+se)*u($1-1,$2-1)+
     &      (so+no)*u($1,$2-1)+(we+ea)*u($1-1,$2)')
define(`relax_ea_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(we+ea)*u($1-1,$2)+
     &      (nw+ne)*u($1-1,$2+1)+(sw+se)*u($1-1,$2-1)')
define(`relax_se_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+(no+so)*u($1,$2+1)+(nw+ne+sw+se)*u($1-1,$2+1)+
     &      (we+ea)*u($1-1,$2)')
define(`relax_so_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+(no+so)*u($1,$2+1)+
     &      ea*u($1+1,$2)+we*u($1-1,$2)+
     &      (ne+se)*u($1+1,$2+1)+(nw+sw)*u($1-1,$2+1)')
define(`relax_sw_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+(no+so)*u($1,$2+1)+(nw+ne+sw+se)*u($1+1,$2+1)+
     &      (ea+we)*u($1+1,$2)')
define(`relax_we_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+no*u($1,$2+1)+
     &      so*u($1,$2-1)+(ea+we)*u($1+1,$2)+
     &      (ne+nw)*u($1+1,$2+1)+(se+sw)*u($1+1,$2-1)')
define(`relax_nw_boundary_g_n_9_c',`u($1,$2)=f($1,$2)+(nw+ne+sw+se)*u($1+1,$2-1)+
     &      (so+no)*u($1,$2-1)+(ea+we)*u($1+1,$2)')

C# s: SOR smoother omega!=1
C# h: homogeneous equation f==0
C# 9: 9 point stencil
C# h: constant coefficients; no=ea=so=we; ne=se=sw=nw
define(`relax_s_h_9_h',`u($1,$2)=ce*u($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+u($1+1,$2)+
     &      u($1-1,$2))+ne*(u($1+1,$2+1)+u($1+1,$2-1)+
     &      u($1-1,$2+1)+u($1-1,$2-1))')
define(`relax_no_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+
     &      no*(2*u($1,$2-1)+u($1+1,$2)+
     &      u($1-1,$2))+2*ne*(u($1+1,$2-1)+u($1-1,$2-1))')
define(`relax_ne_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2-1)+
     &      2*no*(u($1,$2-1)+u($1-1,$2))')
define(`relax_ea_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+
     &      2*u($1-1,$2))+2*ne*(u($1-1,$2+1)+
     &      u($1-1,$2-1))')
define(`relax_se_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2+1)+
     &      no*(2*u($1,$2+1)+2*u($1-1,$2))')
define(`relax_so_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+
     &      no*(2*u($1,$2+1)+u($1+1,$2)+
     &      u($1-1,$2))+2*ne*(u($1+1,$2+1)+u($1-1,$2+1))')
define(`relax_sw_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2+1)+
     &      2*no*(u($1,$2+1)+u($1+1,$2))')
define(`relax_we_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+2*u($1+1,$2))+
     &      2*ne*(u($1+1,$2+1)+u($1+1,$2-1))')
define(`relax_nw_boundary_s_h_9_h',`u($1,$2)=ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2-1)+
     &      2*no*(u($1,$2-1)+u($1+1,$2))')

C# g: standard Gauss-Seidel smoother omega==1
C# h: homogeneous equation f==0
C# 9: 9 point stencil
C# h: constant coefficients; no=ea=so=we; ne=se=sw=nw
define(`relax_g_h_9_h',`u($1,$2)=no*(u($1,$2+1)+
     &      u($1,$2-1)+u($1+1,$2)+u($1-1,$2))+
     &      ne*(u($1+1,$2+1)+u($1+1,$2-1)+
     &      u($1-1,$2+1)+u($1-1,$2-1))')
define(`relax_no_boundary_g_h_9_h',`u($1,$2)=no*(
     &      2*u($1,$2-1)+u($1+1,$2)+u($1-1,$2))+
     &      2*ne*(u($1+1,$2-1)+u($1-1,$2-1))')
define(`relax_ne_boundary_g_h_9_h',`u($1,$2)=(nw+ne+sw+se)*u($1-1,$2-1)+
     &      2*no*(u($1,$2-1)+u($1-1,$2))')
define(`relax_ea_boundary_g_h_9_h',`u($1,$2)=no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1-1,$2))+
     &      2*ne*(u($1-1,$2+1)+u($1-1,$2-1))')
define(`relax_se_boundary_g_h_9_h',`u($1,$2)=(nw+ne+sw+se)*u($1-1,$2+1)+2*no*(u($1,$2+1)+
     &      u($1-1,$2))')
define(`relax_so_boundary_g_h_9_h',`u($1,$2)=no*(2*u($1,$2+1)+
     &      u($1+1,$2)+u($1-1,$2))+
     &      2*ne*(u($1+1,$2+1)+u($1-1,$2+1))')
define(`relax_sw_boundary_g_h_9_h',`u($1,$2)=(nw+ne+sw+se)*u($1+1,$2+1)+2*no*(u($1,$2+1)+
     &      u($1+1,$2))')
define(`relax_we_boundary_g_h_9_h',`u($1,$2)=no*(u($1,$2+1)+
     &      u($1,$2-1)+2*u($1+1,$2))+
     &      2*ne*(u($1+1,$2+1)+u($1+1,$2-1))')
define(`relax_nw_boundary_g_h_9_h',`u($1,$2)=(nw+ne+sw+se)*u($1+1,$2-1)+2*no*(
     &      u($1,$2-1)+u($1+1,$2))')

C# s: SOR smoother omega!=1
C# n: non-homogeneous equation f!=0
C# 9: 9 point stencil
C# h: constant coefficients; no=ea=so=we; ne=se=sw=nw
define(`relax_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+u($1+1,$2)+
     &      u($1-1,$2))+ne*(u($1+1,$2+1)+u($1+1,$2-1)+
     &      u($1-1,$2+1)+u($1-1,$2-1))')
define(`relax_no_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*(2*u($1,$2-1)+u($1+1,$2)+
     &      u($1-1,$2))+2*ne*(u($1+1,$2-1)+
     &      u($1-1,$2-1))')
define(`relax_ne_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2-1)+
     &      2*no*(u($1,$2-1)+u($1-1,$2))')
define(`relax_ea_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+
     &      2*u($1-1,$2))+2*ne*(u($1-1,$2+1)+
     &      u($1-1,$2-1))')
define(`relax_se_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1-1,$2+1)+
     &      2*no*(u($1,$2+1)+u($1-1,$2))')
define(`relax_so_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*(2*u($1,$2+1)+u($1+1,$2)+
     &      u($1-1,$2))+2*ne*(u($1+1,$2+1)+
     &      u($1-1,$2+1))')
define(`relax_sw_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2+1)+
     &      2*no*(u($1,$2+1)+u($1+1,$2))')
define(`relax_we_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+2*u($1+1,$2))+
     &      2*ne*(u($1+1,$2+1)+u($1+1,$2-1))')
define(`relax_nw_boundary_s_n_9_h',`u($1,$2)=f($1,$2)+ce*u($1,$2)+(nw+ne+sw+se)*u($1+1,$2-1)+
     &      2*no*(u($1,$2-1)+u($1+1,$2))')

C# g: standard Gauss-Seidel smoother omega==1
C# n: non-homogeneous equation f!=0
C# 9: 9 point stencil
C# h: constant coefficients; no=ea=so=we; ne=se=sw=nw
define(`relax_g_n_9_h',`u($1,$2)=f($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+u($1+1,$2)+
     &      u($1-1,$2))+ne*(u($1+1,$2+1)+u($1+1,$2-1)+
     &      u($1-1,$2+1)+u($1-1,$2-1))')
define(`relax_no_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+
     &      no*(2*u($1,$2-1)+u($1+1,$2)+
     &      u($1-1,$2))+2*ne*(u($1+1,$2-1)+
     &      u($1-1,$2-1))')
define(`relax_ne_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+(nw+ne+sw+se)*u($1-1,$2-1)+
     &      2*no*(u($1,$2-1)+u($1-1,$2))')
define(`relax_ea_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+
     &      2*u($1-1,$2))+2*ne*(
     &      u($1-1,$2+1)+u($1-1,$2-1))')
define(`relax_se_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+(nw+ne+sw+se)*u($1-1,$2+1)+
     &      2*no*(u($1,$2+1)+
     &      u($1-1,$2))')
define(`relax_so_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+
     &      no*(2*u($1,$2+1)+u($1+1,$2)+
     &      u($1-1,$2))+2*ne*(u($1+1,$2+1)+
     &      u($1-1,$2+1))')
define(`relax_sw_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+(nw+ne+sw+se)*u($1+1,$2+1)+
     &      2*no*(u($1,$2+1)+u($1+1,$2))')
define(`relax_we_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+
     &      no*(u($1,$2+1)+u($1,$2-1)+2*u($1+1,$2))+
     &      2*ne*(u($1+1,$2+1)+u($1+1,$2-1))')
define(`relax_nw_boundary_g_n_9_h',`u($1,$2)=f($1,$2)+(nw+ne+sw+se)*u($1+1,$2-1)+
     &      2*no*(u($1,$2-1)+u($1+1,$2))')
