include(general.m4)
include(relax.m4)
include(rb1.m4)
include(rb2.m4)
include(rb3.m4)
include(rb4.m4)
include(rbheader.m4)

C#--------------------------------------------------------------
C# define 5P solver for standard red-black Gauss-Seidel smoother
C#--------------------------------------------------------------

undefine(`RB_KERN')
define(RB_KERN,RED_BLACK_STANDARD)

define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5c1)

define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5c1)

define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5c1)

define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5c1)

define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5h1)

define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5h1)

define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5h1)

define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5h1)

C#--------------------------------------------------------------
C# define 9P solver for standard red-black Gauss-Seidel smoother
C#--------------------------------------------------------------

define(`relax',`relax_s_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9c1)

define(`relax',`relax_g_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9c1)

define(`relax',`relax_s_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9c1)

define(`relax',`relax_g_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9c1)

define(`relax',`relax_s_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9h1)

define(`relax',`relax_g_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9h1)

define(`relax',`relax_s_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9h1)

define(`relax',`relax_g_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9h1)

C#-----------------------------------------------------------
C# define 5P solver for fused red-black Gauss-Seidel smoother
C#-----------------------------------------------------------

undefine(`RB_KERN')
define(RB_KERN,RED_BLACK_FUSED)

define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5c2)

define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5c2)

define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5c2)

define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5c2)

define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5h2)

define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5h2)

define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5h2)

define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5h2)

C#-----------------------------------------------------------
C# define 9P solver for fused red-black Gauss-Seidel smoother
C#-----------------------------------------------------------

define(`relax',`relax_s_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9c2)

define(`relax',`relax_g_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9c2)

define(`relax',`relax_s_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9c2)

define(`relax',`relax_g_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9c2)

define(`relax',`relax_s_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9h2)

define(`relax',`relax_g_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9h2)

define(`relax',`relax_s_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9h2)

define(`relax',`relax_g_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9h2)

C#----------------------------------------------------------------
C# define 5P solver for 1D blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------

undefine(`RB_KERN')
define(RB_KERN,RED_BLACK_1DBLOCKED)

define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5c3)

define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5c3)

define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5c3)

define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5c3)

define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5h3)

define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5h3)

define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5h3)

define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5h3)

C#----------------------------------------------------------------
C# define 9P solver for 1D blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------

define(`relax',`relax_s_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9c3)

define(`relax',`relax_g_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9c3)

define(`relax',`relax_s_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9c3)

define(`relax',`relax_g_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9c3)

define(`relax',`relax_s_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9h3)

define(`relax',`relax_g_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9h3)

define(`relax',`relax_s_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9h3)

define(`relax',`relax_g_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9h3)

C#-----------------------------------------------------------------------
C# define 5P solver for 2D skewed blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------------

undefine(`RB_KERN')
define(RB_KERN,RED_BLACK_2DBLOCKED_SKEWED)

define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5c4)

define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5c4)

define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5c4)

define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5c4)

define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssh5h4)

define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgh5h4)

define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ssn5h4)

define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(sgn5h4)

C#-----------------------------------------------------------------------
C# define 9P solver for 2D skewed blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------------

define(`relax',`relax_s_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9c4)

define(`relax',`relax_g_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9c4)

define(`relax',`relax_s_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9c4)

define(`relax',`relax_g_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_c($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9c4)

define(`relax',`relax_s_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssh9h4)

define(`relax',`relax_g_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgh9h4)

define(`relax',`relax_s_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(ssn9h4)

define(`relax',`relax_g_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_h($1,$2)')
SUBROUTINE_DIME_RB_9P(sgn9h4)
