C#
C# RED_BLACK_2DBLOCKED_SKEWED is a macro which defines the inner body
C# of the red-black solvers. The implementation uses the fusion
C# optimization technique to improve the cache usage
C#
C# Arguments:
C#  none
C#
C# Implicite arguments:
C#  1: relax macro for inner nodes
C#  2: relax macro for boundary nodes
C#
define(`RED_BLACK_2DBLOCKED_SKEWED',``
	IF (niter .EQ. 2) THEN
C# south boundary handling
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# south preconditioning...
	DO i=1,niter*2-1
	  IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_we_boundary(0,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	  ENDIF
	  DO x=1+mod(i+1,2),nxp-2,2
	    DO y=i,1,-1
	      relax(x,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
	  IF ((btype(2) .EQ. 1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_ea_boundary(nxp-1,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
	ENDDO
C#
C# sliding throug inner part of the grid
	DO topy=4*niter-1,nyp-2,2*niter
C#
C# Build start triangle
	  DO k=topy-2*niter+1,topy-1
	    IF ((btype(4) .EQ. 1) .AND. (mod(k,2).EQ.0)) THEN
	      DO y=k,k-niter*2+1,-2
	        relax_we_boundary(0,y)
	        relax_we_boundary(0,y-1)
	      ENDDO
	    ENDIF
	    DO x=1+mod(k+1,2),topy-k,2
	      DO y=k,k-niter*2+1,-2
	        relax(x,y)
	        relax(x,y-1)
	      ENDDO
	    ENDDO
	  ENDDO
C#
C# Handling inner part of the grid:
C# Sliding throug grid
C#
C# niter=2
	  DO i=1,nxp-5,2
	      y=topy-3
	      relax(i+3,y+0-0)
	      relax(i+2,y+1-0)
	      relax(i+1,y+2-0)
	      relax(i+0,y+3-0)
	      relax(i+3,y+0-1)
	      relax(i+2,y+1-1)
	      relax(i+1,y+2-1)
	      relax(i+0,y+3-1)
	      relax(i+3,y+0-2)
	      relax(i+2,y+1-2)
	      relax(i+1,y+2-2)
	      relax(i+0,y+3-2)
	      relax(i+3,y+0-3)
	      relax(i+2,y+1-3)
	      relax(i+1,y+2-3)
	      relax(i+0,y+3-3)
	  ENDDO
C#
C# Build end triangle
C#
	  DO i=nxp-2*niter,nxp-2,2
	    DO k=0,niter*2-1
	      y=topy-k+2-nxp+i
	      IF (btype(2) .EQ. 1) THEN
	        relax_ea_boundary(nxp-1,y-1)
	      ENDIF
	      DO x=nxp-2,i,-1
	        relax(x,y)
	        y=y+1
	      ENDDO
	    ENDDO
	  ENDDO
C#
C#
C#
	ENDDO
C#
C#     Handling residum of the grid
C#
        DO i=topy-niter*2+1,nyp-2
	  DO y=i,i-niter*2+1,-2
	    IF ((btype(4).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
	    DO x=1+mod(y+1,2),nxp-2,2
              relax(x,y)
              relax(x,y-1)
            ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
          ENDDO
        ENDDO
C#  north boundary (end) handling
	DO i=niter*2-1,1,-1
	  IF (btype(1) .EQ. 1) THEN
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
	  DO y=nyp-2,nyp-1-i,-1
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax(x,y)
	    ENDDO        
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
	  ENDDO
	ENDDO
	IF (btype(1).EQ.1) THEN
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ENDIF
	ELSE IF (niter .EQ. 3) THEN
C# south boundary handling
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# south preconditioning...
	DO i=1,niter*2-1
	  IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_we_boundary(0,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	  ENDIF
	  DO x=1+mod(i+1,2),nxp-2,2
	    DO y=i,1,-1
	      relax(x,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
	  IF ((btype(2) .EQ. 1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_ea_boundary(nxp-1,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
	ENDDO
C#
C# sliding throug inner part of the grid
	DO topy=4*niter-1,nyp-2,2*niter
C#
C# Build start triangle
	  DO k=topy-2*niter+1,topy-1
	    IF ((btype(4) .EQ. 1) .AND. (mod(k,2).EQ.0)) THEN
	      DO y=k,k-niter*2+1,-2
	        relax_we_boundary(0,y)
	        relax_we_boundary(0,y-1)
	      ENDDO
	    ENDIF
	    DO x=1+mod(k+1,2),topy-k,2
	      DO y=k,k-niter*2+1,-2
	        relax(x,y)
	        relax(x,y-1)
	      ENDDO
	    ENDDO
	  ENDDO
C#
C# Handling inner part of the grid:
C# Sliding throug grid
C#
C# niter=3
	  DO i=1,nxp-7,2
	      y=topy-5
	        relax(i+5,y+0-0)
	        relax(i+4,y+1-0)
	        relax(i+3,y+2-0)
	        relax(i+2,y+3-0)
	        relax(i+1,y+4-0)
	        relax(i+0,y+5-0)
	        relax(i+5,y+0-1)
	        relax(i+4,y+1-1)
	        relax(i+3,y+2-1)
	        relax(i+2,y+3-1)
	        relax(i+1,y+4-1)
	        relax(i+0,y+5-1)
	        relax(i+5,y+0-2)
	        relax(i+4,y+1-2)
	        relax(i+3,y+2-2)
	        relax(i+2,y+3-2)
	        relax(i+1,y+4-2)
	        relax(i+0,y+5-2)
	        relax(i+5,y+0-3)
	        relax(i+4,y+1-3)
	        relax(i+3,y+2-3)
	        relax(i+2,y+3-3)
	        relax(i+1,y+4-3)
	        relax(i+0,y+5-3)
	        relax(i+5,y+0-4)
	        relax(i+4,y+1-4)
	        relax(i+3,y+2-4)
	        relax(i+2,y+3-4)
	        relax(i+1,y+4-4)
	        relax(i+0,y+5-4)
	        relax(i+5,y+0-5)
	        relax(i+4,y+1-5)
	        relax(i+3,y+2-5)
	        relax(i+2,y+3-5)
	        relax(i+1,y+4-5)
	        relax(i+0,y+5-5)
	  ENDDO
C#
C# Build end triangle
C#
	  DO i=nxp-2*niter,nxp-2,2
	    DO k=0,niter*2-1
	      y=topy-k+2-nxp+i
	      IF (btype(2) .EQ. 1) THEN
	        relax_ea_boundary(nxp-1,y-1)
	      ENDIF
	      DO x=nxp-2,i,-1
	        relax(x,y)
	        y=y+1
	      ENDDO
	    ENDDO
	  ENDDO
C#
C#
C#
	ENDDO
C#
C#     Handling residum of the grid
C#
        DO i=topy-niter*2+1,nyp-2
	  DO y=i,i-niter*2+1,-2
	    IF ((btype(4).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
	    DO x=1+mod(y+1,2),nxp-2,2
              relax(x,y)
              relax(x,y-1)
            ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
          ENDDO
        ENDDO
C#  north boundary (end) handling
	DO i=niter*2-1,1,-1
	  IF (btype(1) .EQ. 1) THEN
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
	  DO y=nyp-2,nyp-1-i,-1
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax(x,y)
	    ENDDO        
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
	  ENDDO
	ENDDO
	IF (btype(1).EQ.1) THEN
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ENDIF
	ELSE IF (niter .EQ. 4) THEN
C# south boundary handling
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# south preconditioning...
	DO i=1,niter*2-1
	  IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_we_boundary(0,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	  ENDIF
	  DO x=1+mod(i+1,2),nxp-2,2
	    DO y=i,1,-1
	      relax(x,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
	  IF ((btype(2) .EQ. 1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_ea_boundary(nxp-1,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
	ENDDO
C#
C# sliding throug inner part of the grid
	DO topy=4*niter-1,nyp-2,2*niter
C#
C# Build start triangle
	  DO k=topy-2*niter+1,topy-1
	    IF ((btype(4) .EQ. 1) .AND. (mod(k,2).EQ.0)) THEN
	      DO y=k,k-niter*2+1,-2
	        relax_we_boundary(0,y)
	        relax_we_boundary(0,y-1)
	      ENDDO
	    ENDIF
	    DO x=1+mod(k+1,2),topy-k,2
	      DO y=k,k-niter*2+1,-2
	        relax(x,y)
	        relax(x,y-1)
	      ENDDO
	    ENDDO
	  ENDDO
C#
C# Handling inner part of the grid:
C# Sliding throug grid
C#
C# niter=4
	  DO i=1,nxp-9,2
	      y=topy-7
	        relax(i+7,y+0-0)
	        relax(i+6,y+1-0)
	        relax(i+5,y+2-0)
	        relax(i+4,y+3-0)
	        relax(i+3,y+4-0)
	        relax(i+2,y+5-0)
	        relax(i+1,y+6-0)
	        relax(i+0,y+7-0)
	        relax(i+7,y+0-1)
	        relax(i+6,y+1-1)
	        relax(i+5,y+2-1)
	        relax(i+4,y+3-1)
	        relax(i+3,y+4-1)
	        relax(i+2,y+5-1)
	        relax(i+1,y+6-1)
	        relax(i+0,y+7-1)
	        relax(i+7,y+0-2)
	        relax(i+6,y+1-2)
	        relax(i+5,y+2-2)
	        relax(i+4,y+3-2)
	        relax(i+3,y+4-2)
	        relax(i+2,y+5-2)
	        relax(i+1,y+6-2)
	        relax(i+0,y+7-2)
	        relax(i+7,y+0-3)
	        relax(i+6,y+1-3)
	        relax(i+5,y+2-3)
	        relax(i+4,y+3-3)
	        relax(i+3,y+4-3)
	        relax(i+2,y+5-3)
	        relax(i+1,y+6-3)
	        relax(i+0,y+7-3)
	        relax(i+7,y+0-4)
	        relax(i+6,y+1-4)
	        relax(i+5,y+2-4)
	        relax(i+4,y+3-4)
	        relax(i+3,y+4-4)
	        relax(i+2,y+5-4)
	        relax(i+1,y+6-4)
	        relax(i+0,y+7-4)
	        relax(i+7,y+0-5)
	        relax(i+6,y+1-5)
	        relax(i+5,y+2-5)
	        relax(i+4,y+3-5)
	        relax(i+3,y+4-5)
	        relax(i+2,y+5-5)
	        relax(i+1,y+6-5)
	        relax(i+0,y+7-5)
	        relax(i+7,y+0-6)
	        relax(i+6,y+1-6)
	        relax(i+5,y+2-6)
	        relax(i+4,y+3-6)
	        relax(i+3,y+4-6)
	        relax(i+2,y+5-6)
	        relax(i+1,y+6-6)
	        relax(i+0,y+7-6)
	        relax(i+7,y+0-7)
	        relax(i+6,y+1-7)
	        relax(i+5,y+2-7)
	        relax(i+4,y+3-7)
	        relax(i+3,y+4-7)
	        relax(i+2,y+5-7)
	        relax(i+1,y+6-7)
	        relax(i+0,y+7-7)
	  ENDDO
C#
C# Build end triangle
C#
	  DO i=nxp-2*niter,nxp-2,2
	    DO k=0,niter*2-1
	      y=topy-k+2-nxp+i
	      IF (btype(2) .EQ. 1) THEN
	        relax_ea_boundary(nxp-1,y-1)
	      ENDIF
	      DO x=nxp-2,i,-1
	        relax(x,y)
	        y=y+1
	      ENDDO
	    ENDDO
	  ENDDO
C#
C#
C#
	ENDDO
C#
C#     Handling residum of the grid
C#
        DO i=topy-niter*2+1,nyp-2
	  DO y=i,i-niter*2+1,-2
	    IF ((btype(4).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
	    DO x=1+mod(y+1,2),nxp-2,2
              relax(x,y)
              relax(x,y-1)
            ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
          ENDDO
        ENDDO
C#  north boundary (end) handling
	DO i=niter*2-1,1,-1
	  IF (btype(1) .EQ. 1) THEN
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
	  DO y=nyp-2,nyp-1-i,-1
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax(x,y)
	    ENDDO        
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
	  ENDDO
	ENDDO
	IF (btype(1).EQ.1) THEN
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ENDIF
	ELSE
C# south boundary handling
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# south preconditioning...
	DO i=1,niter*2-1
	  IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_we_boundary(0,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	  ENDIF
	  DO x=1+mod(i+1,2),nxp-2,2
	    DO y=i,1,-1
	      relax(x,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
	  IF ((btype(2) .EQ. 1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_ea_boundary(nxp-1,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
	ENDDO
C#
C# sliding throug inner part of the grid
	DO topy=4*niter-1,nyp-2,2*niter
C#
C# Build start triangle
	  DO k=topy-2*niter+1,topy-1
	    IF ((btype(4) .EQ. 1) .AND. (mod(k,2).EQ.0)) THEN
	      DO y=k,k-niter*2+1,-2
	        relax_we_boundary(0,y)
	        relax_we_boundary(0,y-1)
	      ENDDO
	    ENDIF
	    DO x=1+mod(k+1,2),topy-k,2
	      DO y=k,k-niter*2+1,-2
	        relax(x,y)
	        relax(x,y-1)
	      ENDDO
	    ENDDO
	  ENDDO
C#
C# Handling inner part of the grid:
C# Sliding throug grid
C#
	  DO i=1,nxp-2*niter-1,2
	    DO k=0,niter*2-1
	      y=topy-k-niter*2+1
	      DO x=i+niter*2-1,i,-1
	        relax(x,y)
	        y=y+1
	      ENDDO
	    ENDDO
	  ENDDO
C#
C# Build end triangle
C#
	  DO i=nxp-2*niter,nxp-2,2
	    DO k=0,niter*2-1
	      y=topy-k+2-nxp+i
	      IF (btype(2) .EQ. 1) THEN
	        relax_ea_boundary(nxp-1,y-1)
	      ENDIF
	      DO x=nxp-2,i,-1
	        relax(x,y)
	        y=y+1
	      ENDDO
	    ENDDO
	  ENDDO
C#
C#
C#
	ENDDO
C#
C#     Handling residum of the grid
C#
        DO i=topy-niter*2+1,nyp-2
	  DO y=i,i-niter*2+1,-2
	    IF ((btype(4).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
	    DO x=1+mod(y+1,2),nxp-2,2
              relax(x,y)
              relax(x,y-1)
            ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
          ENDDO
        ENDDO
C#  north boundary (end) handling
	DO i=niter*2-1,1,-1
	  IF (btype(1) .EQ. 1) THEN
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
	  DO y=nyp-2,nyp-1-i,-1
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax(x,y)
	    ENDDO        
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
	  ENDDO
	ENDDO
	IF (btype(1).EQ.1) THEN
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ENDIF
	ENDIF'')
