C#
C# RED_BLACK_1DBLOCKED is a macro which defines the inner body
C# of the red-black solvers. The implementation uses the fusion
C# optimization technique to improve the cache usage
C#
C# Arguments:
C#  none
C#
C# Implicite arguments:
C#  1: relax macro for inner nodes
C#  2: relax macro for boundary nodes
C#
define(`RED_BLACK_1DBLOCKED',``
C# south boundary handling
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# south preconditioning...
	DO i=1,niter*2-1
	  IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_we_boundary(0,y)
      	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	  ENDIF
	  DO x=1+mod(i+1,2),nxp-2,2
	    DO y=i,1,-1
	      relax(x,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
	  IF ((btype(2) .EQ. 1) .AND. (mod(i,2).EQ.0)) THEN
	    DO y=i,1,-1
	      relax_ea_boundary(nxp-1,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
	ENDDO
C# Handling inner part of the grid:
C# update red points and black points in pairs
	DO i=niter*2,nyp-2
	  DO y=i,i-niter*2+1,-2
	    IF ((btype(4).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
	    DO x=1+mod(y+1,2),nxp-2,2
	      relax(x,y)
	      relax(x,y-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
	  ENDDO
	ENDDO
C#  north boundary (end) handling
	DO i=niter*2-1,1,-1
	  IF (btype(1).EQ.1) THEN
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
	  DO y=nyp-2,nyp-1-i,-1
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax(x,y)
	    ENDDO        
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
          ENDDO
	ENDDO
	IF (btype(1).EQ.1) THEN
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ENDIF'')
