C#
C# RED_BLACK_FUSED is a macro which defines the inner body
C# of the red-black solvers. The implementation uses the fusion
C# optimization technique to improve the cache usage
C#
C# Arguments:
C#  none
C#
C# Implicite arguments:
C#  1: relax macro for inner nodes
C#  2: relax macro for boundary nodes
C#
define(`RED_BLACK_FUSED',``
	DO i=1,niter
C# south boundary handling
	  IF (btype(3) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_so_boundary(x,0)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
C# south preconditioning...
C# update red points on first inner line   
	  DO x=1,nxp-2,2
	    relax(x,1)
C# relax black points on south boundary if necessary
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)	 
	    ENDIF
	  ENDDO
C# Handling inner part of the grid:
C# update red points and black points in pairs
	  DO y=2,nyp-2
C# west boundary handling
	    IF ((btype(4).EQ.1) .AND. (mod(y,2) .EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
C# inner nodes
	    DO x=1+mod(y+1,2),nxp-2,2
	      relax(x,y)
	      relax(x,y-1)
	    ENDDO
C# east boundary handling
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
	  ENDDO
C#  north boundary (end) handling
	  IF (btype(1) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_nw_boundary(0,nyp-1)
	      relax_we_boundary(0,nyp-2)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	      relax(x,nyp-2)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	      relax_ea_boundary(nxp-1,nyp-2)
	    ENDIF
	    DO x=1,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	  ELSE
	    IF (btype(4) .EQ. 1) THEN
	      relax_we_boundary(0,nyp-2)            
            ENDIF
	    DO x=2,nxp-2,2
	      relax(x,nyp-2)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_ea_boundary(nxp-1,nyp-2)            
            ENDIF
	  ENDIF
	ENDDO'')

