C# RED_BLACK_STANDARD is a macro which defines the inner body
C# of the red-black solvers. The implementation is equivalent
C# to a straightforward implementation of the red-black Gauss-Seidel
C# method
C# Arguments:
C#  none
C# Implicite arguments:
C#  1: relax macro for inner nodes
C#  2: relax macro for boundary nodes=
define(`RED_BLACK_STANDARD',``
C#
	DO i=1,niter
C#  south boundary handling
	  IF (btype(3) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_so_boundary(x,0)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
C#
	  DO y=1,nyp-2
C# west boundary handling
	    IF ((btype(4).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
C#
C# update red-points in center of grid
	    DO x=1+mod(y+1,2),nxp-2,2
	      relax(x,y)
	    ENDDO
C#
C# east boundary handling
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
	  ENDDO
C#  north boundary handling
	  IF (btype(1) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
C#  south boundary handling
	  IF (btype(3) .EQ. 1) THEN
	    DO x=1,nxp-2,2
	      relax_so_boundary(x,0)
	    ENDDO
	  ENDIF
C#
C# update black points
	  DO y=1,nyp-2
	    IF ((btype(4).EQ.1) .AND. (mod(y,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(y,2),nxp-2,2
	      relax(x,y)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)        
	    ENDIF
	  ENDDO
C#  north boundary handling
	  IF (btype(1) .EQ. 1) THEN
	    DO x=1,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	  ENDIF
	ENDDO'')
