include(general.m4)
      PROGRAM testrt
      IMPLICIT NONE

      INTEGER nxp,nyp,padu,padf,nxpc,nypc,paduc,padfc
      PARAMETER (nxp=9,nyp=9,nxpc=(nxp+1)/2,nypc=(nyp+1)/2)
      PARAMETER (padu=0,padf=0,paduc=0,padfc=0)
      DIME_REAL u(nxp+padu,nyp)
      DIME_REAL f(nxp+padf,nyp)
      DIME_REAL uc(nxpc+paduc,nypc)
      DIME_REAL fc(nxpc+padfc,nypc)
      DIME_REAL coeff(9)
      DIME_REAL omega
      INTEGER btype(4)

      DIME_REAL checksum
      DIME_REAL check

C---------------------------------------------------------
C     Constante coefficients for 5-point stencil codes ---
C---------------------------------------------------------

      print *,"---------------------"
      print *,"-- 5-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.25
      coeff(3)=0.25
      coeff(4)=0.25
      coeff(5)=0.25

      omega=1.0

C-----------------------------
C     Dirichlet boundaries ---
C-----------------------------

C      print *,"--------------------------"
C      print *,"-- Dirichlet boundaries --"
C      print *,"--------------------------"

      btype(1)=0
      btype(2)=0
      btype(3)=0
      btype(4)=0


      PRINT *,"Halfinjection..."

      CALL init(u,f,nxp,nyp,padu,padf)

C      PRINT *,"showing u ..."
C      Call show(u,nxp,nyp,padu)

      CALL rsh5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5c1 checksum:",check

C      PRINT *,"showing fc..."
C      Call show(fc,nxpc,nypc,padfc)

      CALL rgh5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5c1 checksum:",check

      CALL rsn5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5c1 checksum:",check

      CALL rgn5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5c1 checksum:",check

      CALL rsh5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5h1 checksum:",check

      CALL rgh5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5h1 checksum:",check

      CALL rsn5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5h1 checksum:",check

      CALL rgn5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5h1 checksum:",check

      PRINT *,"Fullweighting..."

      CALL rsh5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5c2 checksum:",check

      CALL rgh5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5c2 checksum:",check

      CALL rsn5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5c2 checksum:",check

      CALL rgn5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5c2 checksum:",check

      CALL rsh5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5h2 checksum:",check

      CALL rgh5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5h2 checksum:",check

      CALL rsn5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5h2 checksum:",check

      CALL rgn5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5h2 checksum:",check

      print *,"---------------------"
      print *,"-- 9-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.2
      coeff(3)=0.05
      coeff(4)=0.2
      coeff(5)=0.05
      coeff(6)=0.2
      coeff(7)=0.05
      coeff(8)=0.2
      coeff(9)=0.05

      PRINT *,"Halfinjection..."

      CALL rsh9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9c1 checksum:",check

      CALL rgh9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9c1 checksum:",check

      CALL rsn9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9c1 checksum:",check

      CALL rgn9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9c1 checksum:",check

      CALL rsh9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9h1 checksum:",check

      CALL rgh9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9h1 checksum:",check

      CALL rsn9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9h1 checksum:",check

      CALL rgn9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9h1 checksum:",check

      PRINT *,"Fullweighting..."

      CALL rsh9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9c2 checksum:",check

      CALL rgh9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9c2 checksum:",check

      CALL rsn9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9c2 checksum:",check

      CALL rgn9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9c2 checksum:",check

      CALL rsh9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9h2 checksum:",check

      CALL rgh9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9h2 checksum:",check

      CALL rsn9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9h2 checksum:",check

      CALL rgn9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9h2 checksum:",check

C---------------------------
C     Neumann boundaries ---
C---------------------------

      print *,"---------------------"
      print *,"-- 5-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.25
      coeff(3)=0.25
      coeff(4)=0.25
      coeff(5)=0.25

      print *,"------------------------"
      print *,"-- Neumann boundaries --"
      print *,"------------------------"

      btype(1)=1
      btype(2)=1
      btype(3)=1
      btype(4)=1

      PRINT *,"Halfinjection..."

      CALL init(u,f,nxp,nyp,padu,padf)

      CALL rsh5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5c1 checksum:",check

      CALL rgh5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5c1 checksum:",check

      CALL rsn5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5c1 checksum:",check

      CALL rgn5c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5c1 checksum:",check

      CALL rsh5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5h1 checksum:",check

      CALL rgh5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5h1 checksum:",check

      CALL rsn5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5h1 checksum:",check

      CALL rgn5h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5h1 checksum:",check

      PRINT *,"Fullweighting..."

      CALL rsh5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5c2 checksum:",check

      CALL rgh5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5c2 checksum:",check

      CALL rsn5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5c2 checksum:",check

      CALL rgn5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5c2 checksum:",check

      CALL rsh5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh5h2 checksum:",check

      CALL rgh5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh5h2 checksum:",check

      CALL rsn5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn5h2 checksum:",check

      CALL rgn5h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn5h2 checksum:",check

      print *,"---------------------"
      print *,"-- 9-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.2
      coeff(3)=0.05
      coeff(4)=0.2
      coeff(5)=0.05
      coeff(6)=0.2
      coeff(7)=0.05
      coeff(8)=0.2
      coeff(9)=0.05

      PRINT *,"Halfinjection..."

      CALL rsh9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9c1 checksum:",check

      CALL rgh9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9c1 checksum:",check

      CALL rsn9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9c1 checksum:",check

      CALL rgn9c1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9c1 checksum:",check

      CALL rsh9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9h1 checksum:",check

      CALL rgh9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9h1 checksum:",check

      CALL rsn9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9h1 checksum:",check

      CALL rgn9h1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9h1 checksum:",check

      PRINT *,"Fullweighting..."

      CALL rsh9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9c2 checksum:",check

      CALL rgh9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9c2 checksum:",check

      CALL rsn9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9c2 checksum:",check

      CALL rgn9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9c2 checksum:",check

      CALL rsh9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsh9h2 checksum:",check

      CALL rgh9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgh9h2 checksum:",check

      CALL rsn9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rsn9h2 checksum:",check

      CALL rgn9h2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
      check=checksum(fc,nxpc,nypc,padfc)
      PRINT *,"rgn9h2 checksum:",check

      END

C--------------------------
C     utilitiy routines ---
C--------------------------

      SUBROUTINE init(u,f,nxp,nyp,padu,padf)
      IMPLICIT NONE
      INTEGER nxp,nyp,padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      INTEGER i,j
      DO j=0,nyp-1
        DO i=0,nxp-1
          u(i,j)=i*i+j*j*j
          f(i,j)=0.0
        ENDDO
      ENDDO
      END

      DIME_REAL FUNCTION checksum(u,nxp,nyp,padu)
      IMPLICIT NONE
      INTEGER nxp,nyp,padu
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL c
      INTEGER i,j
C
      c=0.0
      DO j=0,nyp-1
        DO i=0,nxp-1
          c=c+u(i,j)
        ENDDO
      ENDDO
C
      checksum=c
      RETURN
      END

      SUBROUTINE show(u,nxp,nyp,padu)
      IMPLICIT NONE
      INTEGER nxp,nyp,padu
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      INTEGER i,j
C
      DO j=0,nyp-1
        DO i=0,nxp-1
          PRINT *,i,j,u(i,j)
        ENDDO
        PRINT *
      ENDDO
      END
