C#-------------------------------------------------------------
C# the macro SUBROUTINE_DIME_RT_5P generates the header for the 
C# 5 point stencil restriction operator
C# Arguments:
C#  1: subroutine name
C# Implicit arguments:
C#  1: subroutine implementation in MACRO RT_KERN
C#  2: residual macro for inner nodes
C#  3: residual macro for boundary nodes
define(`SUBROUTINE_DIME_RT_5P',`
	subroutine $1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
C#
C# parameter types
C#
	IMPLICIT NONE
	INTEGER nxp,nyp,nxpc,nypc
	DIME_REAL coeff(5)
	INTEGER btype(4)
	INTEGER padu,padf,paduc,padfc
	DIME_REAL u(0:nxp+padu-1,0:nyp-1)
	DIME_REAL f(0:nxp+padf-1,0:nyp-1)
	DIME_REAL uc(0:nxpc+paduc-1,0:nypc-1)
	DIME_REAL fc(0:nxpc+padfc-1,0:nypc-1)
	DIME_REAL omega
C#
C# lokal variables
C#
	DIME_REAL ce,no,ea,so,we
	DIME_REAL vlu,vru,vlo,vro,vc,vu,vo,vl,vr
	INTEGER i,k,x,y,xc,yc
C# setting up coefficients for macro
	ce=coeff(1)
	no=coeff(2)
	ea=coeff(3)
	so=coeff(4)
	we=coeff(5)
C# insert implementation of subroutine
	RT_KERN
	END')
C#-------------------------------------------------------------


C#-------------------------------------------------------------
C# the macro SUBROUTINE_DIME_RT_9P generates the header for the 
C# 9 point stencil restriction operator
C# Arguments:
C#  1: subroutine name
C# Implicit arguments:
C#  1: subroutine implementation in MACRO RT_KERN
C#  2: residual macro for inner nodes
C#  3: residula macro for boundary nodes
define(`SUBROUTINE_DIME_RT_9P',`
	subroutine $1(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,fc,padfc,coeff,btype,omega)
C#
C# parameter types
C#
	IMPLICIT NONE
	INTEGER niter,nxp,nyp,nxpc,nypc
	DIME_REAL coeff(9)
	INTEGER btype(4)
	INTEGER padu,padf,paduc,padfc
	DIME_REAL u(0:nxp+padu-1,0:nyp-1)
	DIME_REAL f(0:nxp+padf-1,0:nyp-1)
	DIME_REAL uc(0:nxpc+paduc-1,0:nypc-1)
	DIME_REAL fc(0:nxpc+padfc-1,0:nypc-1)
	DIME_REAL omega
C#
C# lokal variables
C#
	DIME_REAL ce,no,ne,ea,se,so,sw,we,nw
	DIME_REAL vlu,vru,vlo,vro,vc,vu,vo,vl,vr
	INTEGER i,k,x,y,xc,yc
C# setting up coefficients for macro
	ce=coeff(1)
	no=coeff(2)
	ne=coeff(3)
	ea=coeff(4)
	se=coeff(5)
	so=coeff(6)
	sw=coeff(7)
	we=coeff(8)
	nw=coeff(9)
C# insert implementation of subroutine
	RT_KERN
	END')
C#-------------------------------------------------------------
