include(general.m4)
include(residual.m4)
include(relax.m4)

define(`RED_BLACK_FUSED_HW',`
include(restrict-ops-hw-o.m4)
include(pre2-incl-o.m4)')
                                                                                                    
define(`RED_BLACK_1DBLOCKED_HW',`
include(restrict-ops-hw-o.m4)
include(pre3-incl-o.m4)')

define(`RED_BLACK_2DBLOCKED_SKEWED_HW',`
include(restrict-ops-hw-o.m4)
include(pre4-incl-o.m4)')

include(preheader.m4)

C#-----------------------------------------------------------
C# define 9P solver for fused red-black Gauss-Seidel smoother
C#-----------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_FUSED_HW)

define(`residual',`residual_s_h_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_9_c($1,$2)')
define(`relax',`relax_s_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsh9c2)

define(`residual',`residual_g_h_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_9_c($1,$2)')
define(`relax',`relax_g_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgh9c2)

define(`residual',`residual_s_n_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_9_c($1,$2)')
define(`relax',`relax_s_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsn9c2)

define(`residual',`residual_g_n_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_9_c($1,$2)')
define(`relax',`relax_g_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgn9c2)

define(`residual',`residual_s_h_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_9_h($1,$2)')
define(`relax',`relax_s_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsh9h2)

define(`residual',`residual_g_h_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_9_h($1,$2)')
define(`relax',`relax_g_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgh9h2)

define(`residual',`residual_s_n_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_9_h($1,$2)')
define(`relax',`relax_s_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsn9h2)

define(`residual',`residual_g_n_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_9_h($1,$2)')
define(`relax',`relax_g_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgn9h2)

C#----------------------------------------------------------------
C# define 9P solver for 1D blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_1DBLOCKED_HW)

define(`residual',`residual_s_h_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_9_c($1,$2)')
define(`relax',`relax_s_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsh9c3)

define(`residual',`residual_g_h_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_9_c($1,$2)')
define(`relax',`relax_g_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgh9c3)

define(`residual',`residual_s_n_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_9_c($1,$2)')
define(`relax',`relax_s_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsn9c3)

define(`residual',`residual_g_n_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_9_c($1,$2)')
define(`relax',`relax_g_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgn9c3)

define(`residual',`residual_s_h_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_9_h($1,$2)')
define(`relax',`relax_s_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsh9h3)

define(`residual',`residual_g_h_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_9_h($1,$2)')
define(`relax',`relax_g_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgh9h3)

define(`residual',`residual_s_n_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_9_h($1,$2)')
define(`relax',`relax_s_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsn9h3)

define(`residual',`residual_g_n_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_9_h($1,$2)')
define(`relax',`relax_g_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgn9h3)

C#-----------------------------------------------------------------------
C# define 9P solver for 2D skewed blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_2DBLOCKED_SKEWED_HW)

define(`residual',`residual_s_h_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_9_c($1,$2)')
define(`relax',`relax_s_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsh9c4)

define(`residual',`residual_g_h_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_9_c($1,$2)')
define(`relax',`relax_g_h_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgh9c4)

define(`residual',`residual_s_n_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_9_c($1,$2)')
define(`relax',`relax_s_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsn9c4)

define(`residual',`residual_g_n_9_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_9_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_9_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_9_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_9_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_9_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_9_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_9_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_9_c($1,$2)')
define(`relax',`relax_g_n_9_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_c($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgn9c4)

define(`residual',`residual_s_h_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_9_h($1,$2)')
define(`relax',`relax_s_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsh9h4)

define(`residual',`residual_g_h_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_9_h($1,$2)')
define(`relax',`relax_g_h_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgh9h4)

define(`residual',`residual_s_n_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_9_h($1,$2)')
define(`relax',`relax_s_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hsn9h4)

define(`residual',`residual_g_n_9_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_9_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_9_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_9_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_9_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_9_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_9_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_9_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_9_h($1,$2)')
define(`relax',`relax_g_n_9_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_9_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_9_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_9_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_9_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_9_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_9_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_9_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_9_h($1,$2)')
SUBROUTINE_DIME_PRE_9P(hgn9h4)
