include(general.m4)
include(residual.m4)
include(relax.m4)

define(`RED_BLACK_FUSED_HW',`
include(restrict-ops-hw.m4)
include(pre2-incl.m4)')
                                                                                                    
define(`RED_BLACK_1DBLOCKED_HW',`
include(restrict-ops-hw.m4)
include(pre3-incl.m4)')

define(`RED_BLACK_2DBLOCKED_SKEWED_HW',`
include(restrict-ops-hw.m4)
include(pre4-incl.m4)')

include(preheader.m4)

C#-----------------------------------------------------------
C# define 5P solver for fused red-black Gauss-Seidel smoother
C#-----------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_FUSED_HW)

define(`residual',`residual_g_h_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_5_c($1,$2)')
define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgh5c2)

define(`residual',`residual_g_n_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_5_c($1,$2)')
define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgn5c2)

define(`residual',`residual_g_h_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_5_h($1,$2)')
define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgh5h2)

define(`residual',`residual_g_n_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_5_h($1,$2)')
define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgn5h2)

C#----------------------------------------------------------------
C# define 5P solver for 1D blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_1DBLOCKED_HW)

define(`residual',`residual_g_h_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_5_c($1,$2)')
define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgh5c3)

define(`residual',`residual_g_n_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_5_c($1,$2)')
define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgn5c3)

define(`residual',`residual_g_h_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_5_h($1,$2)')
define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgh5h3)

define(`residual',`residual_g_n_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_5_h($1,$2)')
define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgn5h3)

C#-----------------------------------------------------------------------
C# define 5P solver for 2D skewed blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_2DBLOCKED_SKEWED_HW)

define(`residual',`residual_g_h_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_5_c($1,$2)')
define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgh5c4)

define(`residual',`residual_g_n_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_5_c($1,$2)')
define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgn5c4)

define(`residual',`residual_g_h_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_h_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_h_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_h_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_h_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_h_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_h_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_h_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_h_5_h($1,$2)')
define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgh5h4)

define(`residual',`residual_g_n_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_g_n_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_g_n_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_g_n_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_g_n_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_g_n_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_g_n_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_g_n_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_g_n_5_h($1,$2)')
define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(hgn5h4)
