include(general.m4)
include(residual.m4)
include(relax.m4)

define(`RED_BLACK_FUSED_FW',`
include(restrict-ops-fw-o.m4)
include(pre2-incl-o.m4)')
                                                                                                    
define(`RED_BLACK_1DBLOCKED_FW',`
include(restrict-ops-fw-o.m4)
include(pre3-incl-o.m4)')

define(`RED_BLACK_2DBLOCKED_SKEWED_FW',`
include(restrict-ops-fw-o.m4)
include(pre4-incl-o.m4)')

include(preheader.m4)

C#-----------------------------------------------------------
C# define 5P solver for fused red-black Gauss-Seidel smoother
C#-----------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_FUSED_FW)

define(`residual',`residual_s_h_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_5_c($1,$2)')
define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsh5c2)

define(`residual',`residual_s_n_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_5_c($1,$2)')
define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsn5c2)

define(`residual',`residual_s_h_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_5_h($1,$2)')
define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsh5h2)

define(`residual',`residual_s_n_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_5_h($1,$2)')
define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsn5h2)

C#----------------------------------------------------------------
C# define 5P solver for 1D blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_1DBLOCKED_FW)

define(`residual',`residual_s_h_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_5_c($1,$2)')
define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsh5c3)

define(`residual',`residual_s_n_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_5_c($1,$2)')
define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsn5c3)

define(`residual',`residual_s_h_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_5_h($1,$2)')
define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsh5h3)

define(`residual',`residual_s_n_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_5_h($1,$2)')
define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsn5h3)

C#-----------------------------------------------------------------------
C# define 5P solver for 2D skewed blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------------

undefine(`PRE_KERN')
define(PRE_KERN,RED_BLACK_2DBLOCKED_SKEWED_FW)

define(`residual',`residual_s_h_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_5_c($1,$2)')
define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsh5c4)

define(`residual',`residual_s_n_5_c($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_5_c($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_5_c($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_5_c($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_5_c($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_5_c($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_5_c($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_5_c($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_5_c($1,$2)')
define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsn5c4)


define(`residual',`residual_s_h_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_h_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_h_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_h_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_h_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_h_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_h_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_h_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_h_5_h($1,$2)')
define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsh5h4)

define(`residual',`residual_s_n_5_h($1,$2)')
define(`residual_no_boundary',`residual_no_boundary_s_n_5_h($1,$2)')
define(`residual_ne_boundary',`residual_ne_boundary_s_n_5_h($1,$2)')
define(`residual_ea_boundary',`residual_ea_boundary_s_n_5_h($1,$2)')
define(`residual_se_boundary',`residual_se_boundary_s_n_5_h($1,$2)')
define(`residual_so_boundary',`residual_so_boundary_s_n_5_h($1,$2)')
define(`residual_sw_boundary',`residual_sw_boundary_s_n_5_h($1,$2)')
define(`residual_we_boundary',`residual_we_boundary_s_n_5_h($1,$2)')
define(`residual_nw_boundary',`residual_nw_boundary_s_n_5_h($1,$2)')
define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_PRE_5P(fsn5h4)
