`
	DO i=1,niter-1

C# 1) do red-black relaxation without restriction for all
C#    iterations except the last one

C# south boundary handling
	  IF (btype(3) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_so_boundary(x,0)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
C# south preconditioning...
C# update red points on first inner line   
	  DO x=1,nxp-2,2
	    relax(x,1)
C# relax black points on south boundary if necessary
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)	 
	    ENDIF
	  ENDDO
C# Handling inner part of the grid:
C# update red points and black points in pairs
	  DO y=2,nyp-2
C# west boundary handling
	    IF ((btype(4).EQ.1) .AND. (mod(y,2) .EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
C# inner nodes
	    DO x=1+mod(y+1,2),nxp-2,2
	      relax(x,y)
	      relax(x,y-1)
	    ENDDO
C# east boundary handling
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
	  ENDDO
C#  north boundary (end) handling
	  IF (btype(1) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_nw_boundary(0,nyp-1)
	      relax_we_boundary(0,nyp-2)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	      relax(x,nyp-2)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	      relax_ea_boundary(nxp-1,nyp-2)
	    ENDIF
	    DO x=1,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	  ELSE
	    IF (btype(4) .EQ. 1) THEN
	      relax_we_boundary(0,nyp-2)            
            ENDIF
	    DO x=2,nxp-2,2
	      relax(x,nyp-2)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_ea_boundary(nxp-1,nyp-2)            
            ENDIF
	  ENDIF
	ENDDO

C# 2) During last red-black relaxation sweep we want to
C#    combine relaxation, residual calculation, and restriction 

C# 2.1) Build valid start condition

C# 2.1.1) relaxation of south boundary

	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF

C# 2.1.2) south preconditioning...

C#	relaxation of red points on first inner line and
C#	relaxation of black points on south boundary if necessary
	DO x=1,nxp-2,2
	  relax(x,1)
	  IF (btype(3) .EQ. 1) THEN
	    relax_so_boundary(x,0)	 
	  ENDIF
	ENDDO

C#	relaxation of red points on second grid line, black points on
C#      first grid line, and residual calculation on south boundary if
C#      necessary
	IF (btype(4) .EQ. 1) THEN
	  relax_we_boundary(0,2)
	  relax_we_boundary(0,1)
	ENDIF
	DO x=2,nxp-2,2
	  relax(x,2)
          relax(x,1)
	ENDDO
	IF (btype(2) .EQ. 1) THEN
	  relax_ea_boundary(nxp-1,2)
	  relax_ea_boundary(nxp-1,1)
	ENDIF

C#	relaxation of red points on third line, black points on
C#	second line, and residual calculattion on first inner grid
C#	line. Must be handled seperately, since the restriction is
C#	different from grid points which are further away from the boundary
	relax(1,3)
	relax(1,2)
        RESTRICT_NEAR_SW_ODD(1,1)
	DO x=3,nxp-4,2
	  relax(x,3)
	  relax(x,2)
          RESTRICT_NEAR_SO_ODD(x,1)
	ENDDO
	relax(nxp-2,3)
	relax(nxp-2,2)
        RESTRICT_NEAR_SE_ODD(nxp-2,1)

C# 2.2) Lateral moves through the grid
C#      Red and black points are updated in pairs. Restriction is
C#      performed directly after relaxation.
C#      Since the restriction operation is different for even and
C#	odd grid lines the loop is unrolled by a factor of 2 and
C#	odd and even grid lines are handled seperately
	DO y=4,nyp-2,2

C# 2.2.1) smoothing and residual calculation on even grid line
	  IF (btype(4).EQ.1) THEN
	    relax_we_boundary(0,y)
	    relax_we_boundary(0,y-1)
          ELSE
            fc(0,(y-2)/2)=0d0
	  ENDIF
	  DO x=2,nxp-3,2
	    relax(x,y)
	    relax(x,y-1)
            RESTRICT_EVEN(x,y-2)
	  ENDDO
	  IF (btype(2).EQ.1) THEN
	    relax_ea_boundary(nxp-1,y)
	    relax_ea_boundary(nxp-1,y-1)
          ELSE
            fc(nxpc-1,(y-2)/2)=0d0
	  ENDIF

C# 2.2.2) smoothing and residual calculation on odd grid line
	  relax(1,y+1)
	  relax(1,y)
          RESTRICT_NEAR_WE_ODD(1,y-1)
	  DO x=3,nxp-4,2
	    relax(x,y+1)
	    relax(x,y)
            RESTRICT_ODD(x,y-1)
	  ENDDO
	  relax(nxp-2,y+1)
	  relax(nxp-2,y)
          RESTRICT_NEAR_EA_ODD(nxp-2,y-1)

	ENDDO

C# 2.3) Correct relaxations and residum on north boundary

C#	north boundary is a Neumann boundary
	IF (btype(1) .EQ. 1) THEN

C#	  relaxation of red points on north boundary, black points
C#        on last inner grid line, and restriction of the line before
C#        the last inner grid line
	  IF (btype(4) .EQ. 1) THEN
	    relax_nw_boundary(0,nyp-1)
	    relax_we_boundary(0,nyp-2)
          ELSE
            fc(0,(nyp-3)/2)=0d0
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	    relax(x,nyp-2)
	    RESTRICT_EVEN(x,nyp-3)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_ne_boundary(nxp-1,nyp-1)
	    relax_ea_boundary(nxp-1,nyp-2)
          ELSE
            fc(nxpc-1,(nyp-3)/2)=0d0
	  ENDIF

C#	  relaxation of black points on boundary and restriction
C#        of last inner grid line
	  relax_no_boundary(1,nyp-1)
	  RESTRICT_NEAR_NW_ODD(1,nyp-2)
	  DO x=3,nxp-4,2
	    relax_no_boundary(x,nyp-1)
	    RESTRICT_NEAR_NO_ODD(x,nyp-2)
	  ENDDO
	  relax_no_boundary(nxp-2,nyp-1)
	  RESTRICT_NEAR_NE_ODD(nxp-2,nyp-2)


C#      north boundary is a Dirichlet boundary
	ELSE
	  IF (btype(4) .EQ. 1) THEN
	    relax_we_boundary(0,nyp-2)            
          ENDIF
	  DO x=2,nxp-2,2
	    relax(x,nyp-2)
	    RESTRICT_EVEN(x,nyp-3)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_ea_boundary(nxp-1,nyp-2)            
          ENDIF
	  RESTRICT_NEAR_NW_ODD(1,nyp-2)
	  DO x=3,nxp-4,2
	    RESTRICT_NEAR_NO_ODD(x,nyp-2)
	  ENDDO
	  RESTRICT_NEAR_NE_ODD(nxp-2,nyp-2)
	ENDIF

C#	restrict boundary after relaxation...
C#	north boundary...
          IF (btype(1).EQ.1) THEN
C#      north west corner
            IF (btype(4).EQ.1) THEN 
              RESTRICT_NW_BOUNDARY_EVEN(0,nyp-1)
            ELSE
              fc(0,nypc-1)=0.0
            ENDIF
            DO x=2,nxp-3,2
	      RESTRICT_NO_BOUNDARY_EVEN(x,nyp-1)
            ENDDO
C#	north east corner
            IF (btype(2).EQ.1) THEN
              RESTRICT_NE_BOUNDARY_EVEN(nxp-1,nyp-1)
            ELSE
              fc(nxpc-1,nypc-1)=0d0
            ENDIF
          ELSE
            DO xc=0,nxpc-1
              fc(xc,nypc-1)=0d0
            ENDDO
          ENDIF
C#	east boundary
	  IF (btype(2).EQ.1) THEN
            IF (btype(3).EQ.1) THEN
              RESTRICT_SE_BOUNDARY_EVEN(nxp-1,0) 
            ELSE
              fc(nxpc-1,0)=0d0
            ENDIF
            DO y=2,nyp-3,2
    	      RESTRICT_EA_BOUNDARY_EVEN(nxp-1,y)
            ENDDO
          ELSE
            DO yc=0,nypc-2
              fc(nxpc-1,yc)=0d0
            ENDDO
          ENDIF
C#	south boundary
          IF (btype(3).EQ.1) THEN
            IF(btype(4).EQ.1) THEN
              RESTRICT_SW_BOUNDARY_EVEN(0,0)
            ELSE
              fc(0,0)=0d0
            ENDIF
            DO x=2,nxp-3,2
	      RESTRICT_SO_BOUNDARY_EVEN(x,0)
            ENDDO           
	  ELSE
            DO xc=0,nxpc-2
              fc(xc,0)=0d0
            ENDDO
          ENDIF
C#	west boundary
          IF (btype(4).EQ.1) THEN
            DO y=2,nyp-3,2
              RESTRICT_WE_BOUNDARY_EVEN(0,y)            
            ENDDO
          ELSE
            DO yc=1,nypc-2
              fc(0,yc)=0d0            
            ENDDO
          ENDIF

	CALL cleanuc(uc,nxpc,nypc,paduc)
'