include(general.m4)
      PROGRAM testpost
      IMPLICIT NONE

      INTEGER niter,nxp,nyp,padu,padf,nxpc,nypc,paduc
      PARAMETER (niter=2,nxp=5,nyp=5,nxpc=nxp/2+1,nypc=nyp/2+1,padu=0,padf=0,paduc=0)

      DIME_REAL checksum

      DIME_REAL coeff(9)
      INTEGER btype(4)
      DIME_REAL u(nxp+padu,nyp)
      DIME_REAL uc(nxpc+paduc,nypc)
      DIME_REAL f(nxp+padf,nyp)
      DIME_REAL curcheck
      DIME_REAL check
      INTEGER i

C---------------------------------------------------------
C     Constante coefficients for 5-point stencil codes ---
C---------------------------------------------------------

      print *,"---------------------"
      print *,"-- 5-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.25
      coeff(3)=0.25
      coeff(4)=0.25
      coeff(5)=0.25

C      CALL showu(u,nxp,nyp,padu)

C-----------------------------
C     Dirichlet boundaries ---
C-----------------------------

      print *,"--------------------------"
      print *,"-- Dirichlet boundaries --"
      print *,"--------------------------"

      btype(1)=0
      btype(2)=0
      btype(3)=0
      btype(4)=0


      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn5c3(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn5c4(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C---------------------------
C     Neumann boundaries ---
C---------------------------

      print *,"------------------------"
      print *,"-- Neumann boundaries --"
      print *,"------------------------"

      btype(1)=1
      btype(2)=1
      btype(3)=1
      btype(4)=1

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn5c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn5c3(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn5c4(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C---------------------------------------------------------
C     Constante coefficients for 9-point stencil codes ---
C---------------------------------------------------------

      print *,"---------------------"
      print *,"-- 9-point stencil --"
      print *,"---------------------"

      coeff(1)=0.0
      coeff(2)=0.2
      coeff(3)=0.05
      coeff(4)=0.2
      coeff(5)=0.05
      coeff(6)=0.2
      coeff(7)=0.05
      coeff(8)=0.2
      coeff(9)=0.05

C-----------------------------
C     Dirichlet boundaries ---
C-----------------------------

      print *,"--------------------------"
      print *,"-- Dirichlet boundaries --"
      print *,"--------------------------"

      btype(1)=0
      btype(2)=0
      btype(3)=0
      btype(4)=0

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn9c3(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn9c4(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C---------------------------
C     Neumann boundaries ---
C---------------------------

      print *,"------------------------"
      print *,"-- Neumann boundaries --"
      print *,"------------------------"

      btype(1)=1
      btype(2)=1
      btype(3)=1
      btype(4)=1

      PRINT *,"Fused..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn9c2(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"1D Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn9c3(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

      PRINT *,"2D Skewed Blocked..."

      CALL init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      CALL osn9c4(nxp,nyp,u,padu,f,padf,nxpc,nypc,uc,paduc,niter,coeff,btype)
      check=checksum(u,nxp,nyp,padu)
      PRINT *,"checksum:",check

C------------------
C test finished ---
C------------------

      END

C--------------------------
C     utilitiy routines ---
C--------------------------

      SUBROUTINE init(u,f,nxp,nyp,padu,padf,uc,nxpc,nypc,paduc)
      INTEGER nxp,nyp,padu,padf,nxpc,nypc,paduc
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL uc(0:nxpc+paduc-1,0:nypc-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      INTEGER i,j
C init finer grid
      DO j=0,nyp-1
        DO i=0,nxp+padu-1
          u(i,j)=0.0 
        ENDDO
      ENDDO
      DO j=0,nyp-1
        DO i=0,nxp+padf-1
          f(i,j)=0.0 
        ENDDO
      ENDDO
      DO i=0,nxp-1
        u(i,nyp-1)=(1.0/nxp)*i
        u(i,0)=(1.0/nxp)*(nxp-1-i)
      ENDDO
      DO i=0,nyp-1
        u(nxp-1,i)=(1.0/nyp)*i
        u(0,i)=(1.0/nyp)*(nyp-1-i)
      ENDDO

C init coarser grid
      DO i=0,nxpc-1
        uc(i,0)=2.0
      ENDDO
      DO j=1,nypc-2
        uc(0,j)=2.0
        DO i=1,nxpc-2
          uc(i,j)=i*i+2.5*j*j*j
        ENDDO
        uc(nxpc-1,j)=2.0
      ENDDO
      DO i=0,nxpc-1
        uc(i,nypc-1)=2.0
      ENDDO

      END

      DIME_REAL FUNCTION checksum(u,nxp,nyp,padu)
      IMPLICIT NONE
      INTEGER padu,nxp,nyp
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL c
      INTEGER i,j
C
      c=0.0
      DO j=0,nyp-1
        DO i=0,nxp-1
          c=c+u(i,j)
        ENDDO
      ENDDO
C
      checksum=c
      RETURN
      END

      SUBROUTINE showu(u,nxp,nyp,padu)
      IMPLICIT NONE
      INTEGER nxp,nyp,padu
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      INTEGER i,j
C
      DO j=0,nyp-1
        DO i=0,nxp-1
          PRINT *,i,j,u(i,j)
        ENDDO
        PRINT *
      ENDDO
      END
