C#
C# RED_BLACK_2DBLOCKED_SKEWED is a macro which defines the inner body
C# of the red-black solvers. The implementation uses the fusion
C# optimization technique to improve the cache usage
C#
C# Arguments:
C#  none
C#
C# Implicite arguments:
C#  1: relax macro for inner nodes
C#  2: relax macro for boundary nodes
C#
define(`RED_BLACK_2DBLOCKED_SKEWED',``
C# 1) Perform interpolation of first two grid lines
C#    Interpolation of the two grid lines is done
C#    during one lateral move through the grid

        xc=0
        vlu=uc(xc,0)
        vlo=uc(xc,1)
        DO x=0,nxp-3,2
          vru=uc(xc+1,0)
          vro=uc(xc+1,1)
C#          print *,"i",x,",",0
          u(x,0)=u(x,0)+c1*vlu
C#          print *,"i",x,",",1
          u(x,1)=u(x,1)+c2*(vlu+vlo)
C#          print *,"i",x+1,",",0
          u(x+1,0)=u(x+1,0)+c2*(vlu+vru)
C#          print *,"i",x+1,",",1
          u(x+1,1)=u(x+1,1)+c3*(vlu+vlo+vru+vro)
          vlo=vro
          vlu=vru
          xc=xc+1
        ENDDO
C#        print *,"i",nxp-1,",",0
        u(nxp-1,0)=u(nxp-1,0)+c1*vru
C#        print *,"i",nxp-1,",",1
        u(nxp-1,0+1)=u(nxp-1,0+1)+c2*(vru+vro)
C# 2) we have to build a valid start condition in the sothern area
C#    of the grid before we can start sliding through the grid:
C# 2.1) relaxation of south boundary
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# 2.2) building start wave
C#      the interpolation is different for even and odd grid lines
C#      since we do not want to use conditional branches we unroll the
C#      smoothing loop by two and modify the replikated loop body
C#      accordingly
	DO i=1,niter*2-2,2
C# 2.2.1) smoothing of the odd grid line:
C# --------------------------------------
          k=i
C#          print *,"i",0,",",k+1
          u(0,k+1)=u(0,k+1)+c1*uc(0,(k+1)/2)
	  DO x=1,nxp-2,2
C#            print *,"i",x,",",k+1
            u(x,k+1)=u(x,k+1)+c2*(uc(x/2,(k+1)/2)+uc(x/2+1,(k+1)/2))
C#            print *,"i",x+1,",",k+1
            u(x+1,k+1)=u(x+1,k+1)+c1*uc(x/2+1,(k+1)/2)
	    DO y=k,1,-1
	      relax(x,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
C# 2.2.2) smoothing of the even grid line:
C#----------------------------------------
          k=i+1
C#          print *,"i",0,",",k+1
          u(0,k+1)=u(0,k+1)+c2*(uc(0,(k+1)/2)+uc(0,(k+1)/2+1))
C#          print *,"i",1,",",k+1
          u(1,k+1)=u(1,k+1)+c3*(uc(0,(k+1)/2)+uc(0,(k+1)/2+1)+(uc(1,(k+1)/2)+uc(1,(k+1)/2+1)))
C#          print *,"i",nxp-1,",",k+1
          u(nxp-1,k+1)=u(nxp-1,k+1)+c2*(uc(nxpc-1,(k+1)/2)+uc(nxpc-1,(k+1)/2+1))
	  IF (btype(4).EQ.1) THEN
	    DO y=k,1,-1
	      relax_we_boundary(0,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	  ENDIF
	  DO x=2,nxp-2,2
C#            print *,"i",x,",",k+1
            u(x,k+1)=u(x,k+1)+c2*(uc(x/2,(k+1)/2)+uc(x/2,(k+1)/2+1))
C#            print *,"i",x+1,",",k+1
            u(x+1,k+1)=u(x+1,k+1)+c3*(uc(x/2,(k+1)/2)+uc(x/2,(k+1)/2+1)+uc(x/2+1,(k+1)/2)+uc(x/2+1,(k+1)/2+1))
	    DO y=k,1,-1
	      relax(x,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    DO y=k,1,-1
	      relax_ea_boundary(nxp-1,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
	ENDDO
C# 2.2.3) We have an odd number of grid lines (without the boundary) to handle during
C#        the handling of the southern area. Therefore, we have to handle the northern
C#        grid line seperately
        k=niter*2-1
C#        print *,"i",0,",",k+1
        u(0,k+1)=u(0,k+1)+c1*uc(0,(k+1)/2)
	DO x=1,nxp-2,2
C#          print *,"i",x,",",k+1
          u(x,k+1)=u(x,k+1)+c2*(uc(x/2,(k+1)/2)+uc(x/2+1,(k+1)/2))
C#          print *,"i",x+1,",",k+1
          u(x+1,k+1)=u(x+1,k+1)+c1*uc(x/2+1,(k+1)/2)
	  DO y=k,1,-1
	    relax(x,y)
	  ENDDO
	  IF (btype(3) .EQ. 1) THEN
	    relax_so_boundary(x,0)
	  ENDIF
	ENDDO
C# 3) several lateral moves through the grid
	DO topy=4*niter-1,nyp-2,2*niter
C# 3.1) build start interpolation triangle
	  DO y=topy-2*niter+2,topy+1,2
	    DO x=0,topy-y-1,2
C#              print *,"i",x,",",y
	      u(x,y)=u(x,y)+c2*(uc(x/2,y/2)+uc(x/2,y/2+1))
C#              print *,"i",x,",",y+1
              u(x,y+1)=u(x,y+1)+c1*uc(x/2,y/2+1)
C#              print *,"i",x+1,",",y
              u(x+1,y)=u(x+1,y)+c3*(uc(x/2,y/2)+uc(x/2,y/2+1)+uc(x/2+1,y/2)+uc(x/2+1,y/2+1))
C#              print *,"i",x+1,",",y+1
              u(x+1,y+1)=u(x+1,y+1)+c2*(uc(x/2,y/2+1)+uc(x/2+1,y/2+1))
	    ENDDO
C#            print *,"i",topy-y,",",y
            u(topy-y,y)=u(topy-y,y)+c2*(uc((topy-y)/2,y/2)+uc((topy-y)/2,y/2+1))
C#            print *,"i",topy-y,",",y+1
            u(topy-y,y+1)=u(topy-y,y+1)+c1*uc((topy-y)/2,y/2+1)
C#            print *,"i",topy-y+1,",",y
            u(topy-y+1,y)=u(topy-y+1,y)+c3*(uc((topy-y)/2,y/2)+uc((topy-y)/2,y/2+1)+uc((topy-y)/2+1,y/2)+uc((topy-y)/2+1,y/2+1))
	  ENDDO
C# 3.2) build start triangle for relaxation sweep
	  DO k=topy-2*niter+1,topy-1
	    IF ((btype(4) .EQ. 1) .AND. (mod(k,2).EQ.0)) THEN
	      DO y=k,k-niter*2+1,-2
	        relax_we_boundary(0,y)
	        relax_we_boundary(0,y-1)
	      ENDDO
	    ENDIF
	    DO x=1+mod(k+1,2),topy-k,2
	      DO y=k,k-niter*2+1,-2
	        relax(x,y)
	        relax(x,y-1)
	      ENDDO
	    ENDDO
	  ENDDO
C# 3.3) move lateral through the grid
	  DO i=1,nxp-2*niter-1,2
C# 3.3.1) build interpolation front
	    x=i+niter*2-1
            DO y=topy-niter*2+2,topy+1,2
C#              print *,"i",x,",",y
              u(x,y)=u(x,y)+c2*(uc(x/2,y/2)+uc(x/2,(y+1)/2))
C#              print *,"i",x+1,",",y
              u(x+1,y)=u(x+1,y)+c3*(uc(x/2,y/2)+uc(x/2,(y+1)/2)+uc(x/2+1,y/2)+uc(x/2+1,(y+1)/2))
C#              print *,"i",x-1,",",y+1
              u(x-1,y+1)=u(x-1,y+1)+c2*(uc(x/2-1,(y+1)/2)+uc(x/2,(y+1)/2))
C#              print *,"i",x,",",y+1
              u(x,y+1)=u(x,y+1)+c1*uc(x/2,(y+1)/2)
	      x=x-2
            ENDDO
C# 3.3.2) Relaxtion of block
	    DO k=0,niter*2-1
	      y=topy-k-niter*2+1
	      DO x=i+niter*2-1,i,-1
	        relax(x,y)
	        y=y+1
	      ENDDO
	    ENDDO
          ENDDO
C# 3.4) build end interpolation triangle
          DO y=topy-2*niter+3,topy+1,2
            k=nxp-2-(y-(topy-2*niter+3))
C#            print *,"i",k+1,",",y-1
            u(k+1,y-1)=u(k+1,y-1)+c2*(uc((k+1)/2,y/2)+uc((k+1)/2,y/2-1))
C#            print *,"i",k,",",y
            u(k,y)=u(k,y)+c2*(uc((k+1)/2-1,y/2)+uc((k+1)/2,y/2))
C#            print *,"i",k+1,",",y
            u(k+1,y)=u(k+1,y)+c1*uc((k+1)/2,y/2)
	    DO x=k+2,nxp-2,2
C#              print *,"i",x,",",y-1
              u(x,y-1)=u(x,y-1)+c3*(uc(x/2,(y-1)/2)+uc(x/2,y/2)+uc(x/2+1,(y-1)/2)+uc(x/2+1,y/2))
C#              print *,"i",x,",",y
              u(x,y)=u(x,y)+c2*(uc(x/2,y/2)+uc(x/2+1,y/2))
C#              print *,"i",x+1,",",y-1
              u(x+1,y-1)=u(x+1,y-1)+c2*(uc(x/2+1,(y-1)/2)+uc(x/2+1,y/2))
C#              print *,"i",x+1,",",y
              u(x+1,y)=u(x+1,y)+c1*uc(x/2+1,y/2)
            ENDDO
          ENDDO
C# 3.5) Build end relaxation triangle
	  DO i=nxp-2*niter,nxp-2,2
	    DO k=0,niter*2-1
	      y=topy-k+2-nxp+i
	      IF (btype(2) .EQ. 1) THEN
	        relax_ea_boundary(nxp-1,y-1)
	      ENDIF
	      DO x=nxp-2,i,-1
	        relax(x,y)
	        y=y+1
	      ENDDO
	    ENDDO
	  ENDDO
	ENDDO
C# 4) Handling residum of the grid
C#    The twodimensional block does not slide horizontal through the
C#    grid but jumps over several grid lines which were processed
C#    during one lateral move through the grid. Hence, for some
C#    grid sizes some grid lines are left over after the uppermost
C#    lateral move. The relaxation of these grid lines is done with
C#    1D blocked red-black
        DO i=topy-niter*2+1,nyp-2,2
C# 4.1) smoothing the even grid line
C# ---------------------------------
C#          print *,"i",0,",",i+1
          u(0,i+1)=u(0,i+1)+c2*(uc(0,(i+1)/2)+uc(0,(i+1)/2+1))
C#          print *,"i",1,",",i+1
          u(1,i+1)=u(1,i+1)+c3*(uc(0,(i+1)/2)+uc(0,(i+1)/2+1)+uc(1,(i+1)/2)+uc(1,(i+1)/2+1))
C#          print *,"i",nxp-1,",",i+1
          u(nxp-1,i+1)=u(nxp-1,i+1)+c2*(uc(nxpc-1,(i+1)/2)+uc(nxpc-1,(i+1)/2+1))
          y=i
	  DO x=2,nxp-2,2
C#            print *,"i",x,",",y+1
            u(x,y+1)=u(x,y+1)+c2*(uc(x/2,(y+1)/2)+uc(x/2,(y+1)/2+1))
C#            print *,"i",x+1,",",y+1
            u(x+1,y+1)=u(x+1,y+1)+c3*(uc(x/2,(y+1)/2)+uc(x/2,(y+1)/2+1)+uc(x/2+1,(y+1)/2)+uc(x/2+1,(y+1)/2+1))
            relax(x,y)
            relax(x,y-1)
          ENDDO
	  DO y=i+2,i-niter*2+1,-2
	    IF (btype(4).EQ.1) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
	    DO x=2,nxp-2,2
              relax(x,y)
              relax(x,y-1)
            ENDDO
	    IF (btype(2).EQ.1) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
          ENDDO
C# 4.2) smoothing the odd grid line
C#---------------------------------
C#          print *,"i",0,",",i+2
          u(0,i+2)=u(0,i+2)+c1*uc(0,(i+2)/2)
          y=i+1
          DO x=1,nxp-2,2
C#            print *,"i",x,",",y+1
            u(x,y+1)=u(x,y+1)+c2*(uc(x/2,(y+1)/2)+uc(x/2+1,(y+1)/2))
C#            print *,"i",x+1,",",y+1
            u(x+1,y+1)=u(x+1,y+1)+c1*uc(x/2+1,(y+1)/2)
            relax(x,y)
            relax(x,y-1)
          ENDDO
	  DO y=i+3,i-niter*2+2,-2
	    DO x=1,nxp-2,2
              relax(x,y)
              relax(x,y-1)
            ENDDO
          ENDDO
        ENDDO
C# 5) At the end we have to relax the grid points in the
C#    northern area so that every node is relaxed niter times
C#    no interpolation has to be done here!
	DO i=niter*2-1,1,-1
C#        relax grid points on north boundary
	  IF (btype(1) .EQ. 1) THEN
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
C#        relax grid points northern area of the inner grid
	  DO y=nyp-2,nyp-1-i,-1
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax(x,y)
	    ENDDO        
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
	  ENDDO
	ENDDO
C#      for the last time relax all the black points on
C#      north boundary
	IF (btype(1).EQ.1) THEN
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ENDIF'')
