C# RED_BLACK_1DBLOCKED is a macro which defines the inner body
C# of the red-black solvers. The implementation uses the fusion
C# optimization technique to improve the cache usage
C# Arguments:
C#  none
C# Implicite arguments:
C#  1: relax macro for inner nodes
C#  2: relax macro for boundary nodes
define(`RED_BLACK_1DBLOCKED',``
C# 1) Perform interpolation of first two grid lines
C#    Interpolation of the two grid lines is done
C#    during one lateral move through the grid
        xc=0
        vlu=uc(xc,0)
        vlo=uc(xc,1)
        DO x=0,nxp-3,2
          vru=uc(xc+1,0)
          vro=uc(xc+1,1)
C#          print *,"i",x,",",0
          u(x,0)=u(x,0)+c1*vlu
C#          print *,"i",x,",",1
          u(x,1)=u(x,1)+c2*(vlu+vlo)
C#          print *,"i",x+1,",",0
          u(x+1,0)=u(x+1,0)+c2*(vlu+vru)
C#          print *,"i",x+1,",",1
          u(x+1,1)=u(x+1,1)+c3*(vlu+vlo+vru+vro)
          vlo=vro
          vlu=vru
          xc=xc+1
        ENDDO
C#        print *,"i",nxp-1,",",0
        u(nxp-1,0)=u(nxp-1,0)+c1*vru
C#        print *,"i",nxp-1,",",1
        u(nxp-1,0+1)=u(nxp-1,0+1)+c2*(vru+vro)
C# 2) we have to build a valid start condition in the sothern area
C#    of the grid before we can start sliding through the grid:
C# 2.1) relaxation of south boundary
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# 2.2) building start wave
C#      the interpolation is different for even and odd grid lines
C#      since we do not want to use conditional branches we unroll the
C#      smoothing loop by two and modify the replikated loop body
C#      accordingly
	DO i=1,niter*2-2,2
C# 2.2.1) smoothing of the odd grid line:
C# --------------------------------------
C#        interpolating western boundary point
C#          print *,"i",0,",",i+1
          u(0,i+1)=u(0,i+1)+c1*uc(0,(i+1)/2)
	  DO x=1,nxp-2,2
C#          interpolation of the grid point to the nort and northeast
C#          of the red point which will be updated next
C#            print *,"i",x,",",i+1
            u(x,i+1)=u(x,i+1)+c2*(uc(x/2,(i+1)/2)+uc(x/2+1,(i+1)/2))
C#            print *,"i",x+1,",",i+1
            u(x+1,i+1)=u(x+1,i+1)+c1*uc(x/2+1,(i+1)/2)
C#          update the red point and the points below
	    DO y=i,1,-1
	      relax(x,y)
	    ENDDO
C#          if the boundary is a Neumann boundary we have to
C#          take care of this grid point as well
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
C# 2.2.2) smoothing of the even grid line:
C#----------------------------------------
C#        interpolation of the western, eastern boundary, and
C#        the left most inner grid point
C#          print *,"i",0,",",i+2
          u(0,i+2)=u(0,i+2)+c2*(uc(0,(i+2)/2)+uc(0,(i+2)/2+1))
C#          print *,"i",1,",",i+2
          u(1,i+2)=u(1,i+2)+c3*(uc(0,(i+2)/2)+uc(0,(i+2)/2+1)+(uc(1,(i+2)/2)+uc(1,(i+2)/2+1)))
C#          print *,"i",nxp-1,",",i+2
          u(nxp-1,i+2)=u(nxp-1,i+2)+c2*(uc(nxpc-1,(i+2)/2)+uc(nxpc-1,(i+2)/2+1))
C#        relaxation of western boundary grid points
	  IF (btype(4).EQ.1) THEN
	    DO y=i+1,1,-1
	      relax_we_boundary(0,y)
      	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	  ENDIF
C#        relaxation of inner grid points
	  DO x=2,nxp-2,2
C#          interpolation of the grid point to the nort and northeast
C#          of the red point which will be updated next
C#            print *,"i",x,",",i+2
            u(x,i+2)=u(x,i+2)+c2*(uc(x/2,(i+2)/2)+uc(x/2,(i+2)/2+1))
C#            print *,"i",x+1,",",i+2
            u(x+1,i+2)=u(x+1,i+2)+c3*(uc(x/2,(i+2)/2)+uc(x/2,(i+2)/2+1)+uc(x/2+1,(i+2)/2)+uc(x/2+1,(i+2)/2+1))
C#          update the red point and the points below
	    DO y=i+1,1,-1
	      relax(x,y)
	    ENDDO
C#          if the boundary is a Neumann boundary we have to
C#          take care of this grid point as well
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)
	    ENDIF
	  ENDDO
C#        relaxation of eastern boundary grid points
	  IF (btype(2) .EQ. 1) THEN
	    DO y=i+1,1,-1
	      relax_ea_boundary(nxp-1,y)
	    ENDDO
	    IF (btype(3) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF

	ENDDO
C# 2.2.3) We have an odd number of grid lines (without the boundary) to handle during
C#        the handling of the southern area. Therefore, we have to handle the northern
C#        grid line seperately
C#      interpolating western boundary point
C#        print *,"i",0,",",niter*2
        u(0,niter*2)=u(0,niter*2)+c1*uc(0,niter)
C#      relaxation of inner grid points
	DO x=1,nxp-2,2
C#        interpolation of the grid point to the nort and northeast
C#        of the red point which will be updated next
C#          print *,"i",x,",",niter*2
          u(x,niter*2)=u(x,niter*2)+c2*(uc(x/2,niter)+uc((x+1)/2,niter))
C#          print *,"i",x+1,",",niter*2
          u(x+1,niter*2)=u(x+1,niter*2)+c1*uc((x+1)/2,niter)
C#        update the red point and the points below
	  DO y=niter*2-1,1,-1
	    relax(x,y)
	  ENDDO
C#        if the boundary is a Neumann boundary we have to
C#        take care of this grid point as well
	  IF (btype(3) .EQ. 1) THEN
	    relax_so_boundary(x,0)
	  ENDIF
	ENDDO
C# 3) Handling inner part of the grid:
C#    update red points and black points in pairs. Before updating a node the grid points
C#    to the north and northeast are interpolated. Even and odd grid lines are (again)
C#    handled seperately. We have to peel the first iteration of the blocked update
C#    sweep to perform interpolation
	DO i=niter*2,nyp-3,2
C# 3.1) smoothing even grid lines
C# ------------------------------
C#        interpolation of boundary grid points and first inner grid point
C#          print *,"i",0,",",i+1
          u(0,i+1)=u(0,i+1)+c2*(uc(0,(i+1)/2)+uc(0,(i+1)/2+1))
C#          print *,"i",1,",",i+1
          u(1,i+1)=u(1,i+1)+c3*(uc(0,(i+1)/2)+uc(0,(i+1)/2+1)+uc(1,(i+1)/2)+uc(1,(i+1)/2+1))
C#          print *,"i",nxp-1,",",i+1
          u(nxp-1,i+1)=u(nxp-1,i+1)+c2*(uc(nxpc-1,(i+1)/2)+uc(nxpc-1,(i+1)/2+1))
C#        interpolation of grid points to the north and northeast
C#        of the red point which is relaxed next. Furthermore, we
C#        update the black point which is directly below the red point
          y=i
	  IF (btype(4).EQ.1) THEN
	    relax_we_boundary(0,y)
	    relax_we_boundary(0,y-1)
	  ENDIF
	  DO x=2,nxp-2,2
C#            print *,"i",x,",",y+1
            u(x,y+1)=u(x,y+1)+c2*(uc(x/2,(y+1)/2)+uc(x/2,(y+1)/2+1))
C#            print *,"i",x+1,",",y+1
            u(x+1,y+1)=u(x+1,y+1)+c3*(uc(x/2,(y+1)/2)+uc(x/2,(y+1)/2+1)+uc(x/2+1,(y+1)/2)+uc(x/2+1,(y+1)/2+1))
	    relax(x,y)
	    relax(x,y-1)
	  ENDDO
	  IF (btype(2).EQ.1) THEN
	    relax_ea_boundary(nxp-1,y)
	    relax_ea_boundary(nxp-1,y-1)
	  ENDIF
C#        the niter*2-2 grid points below are relaxed next
	  DO y=i-2,i-niter*2+1,-2
	    IF (btype(4).EQ.1) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax(x,y)
	      relax(x,y-1)
	    ENDDO
	    IF (btype(2).EQ.1) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
	  ENDDO
C# 3.2) smoothing of the odd grid line:
C# ------------------------------------
C#        interpolation of west boundary grid point
C#          print *,"i",0,",",i+2
          u(0,i+2)=u(0,i+2)+c1*uc(0,(i+2)/2)
C#        interpolation of grid points to the north and northeast
C#        of the red point which is relaxed next. Furthermore, we
C#        update the black point which is directly below the red point
          y=i+1
	  DO x=1,nxp-2,2
C#            print *,"i",x,",",y+1
            u(x,y+1)=u(x,y+1)+c2*(uc(x/2,(y+1)/2)+uc(x/2+1,(y+1)/2))
C#            print *,"i",x+1,",",y+1
            u(x+1,y+1)=u(x+1,y+1)+c1*uc(x/2+1,(y+1)/2)
	    relax(x,y)
	    relax(x,y-1)
	  ENDDO
C#        the niter*2-2 grid points below are relaxed next
          DO y=i-1,i-niter*2+2,-2
	    DO x=1,nxp-2,2
	      relax(x,y)
	      relax(x,y-1)
	    ENDDO
	  ENDDO
	ENDDO
C# 4) At the end we have to relax the grid points in the
C#    northern area so that every node is relaxed niter times
C#    no interpolation has to be done here!
	DO i=niter*2-1,1,-1
C#        relax grid points on north boundary
	  IF (btype(1).EQ.1) THEN
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_nw_boundary(0,nyp-1)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	    ENDIF
	  ENDIF
C#        relax grid points northern area of the inner grid
	  DO y=nyp-2,nyp-1-i,-1
	    IF ((btype(4).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_we_boundary(0,y)
	    ENDIF
	    DO x=1+mod(i,2),nxp-2,2
	      relax(x,y)
	    ENDDO        
	    IF ((btype(2).EQ.1) .AND. (mod(i,2).EQ.1)) THEN
	      relax_ea_boundary(nxp-1,y)
	    ENDIF
          ENDDO
	ENDDO
C#      for the last time relax all the black points on
C#      north boundary
	IF (btype(1).EQ.1) THEN
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ENDIF'')
