C#
C# RED_BLACK_FUSED is a macro which defines the inner body
C# of the red-black solvers. The implementation uses the fusion
C# optimization technique to improve the cache usage
C#
C# Arguments:
C#  none
C#
C# Implicite arguments:
C#  1: relax macro for inner nodes
C#  2: relax macro for boundary nodes
C#
define(`RED_BLACK_FUSED',``
        xc=0
        vlu=uc(xc,0)
        vlo=uc(xc,1)
        DO x=0,nxp-3,2
          vru=uc(xc+1,0)
          vro=uc(xc+1,1)
          u(x,0)=u(x,0)+c1*vlu
          u(x,1)=u(x,1)+c2*(vlu+vlo)
          u(x+1,0)=u(x+1,0)+c2*(vlu+vru)
          u(x+1,1)=u(x+1,1)+c3*(vlu+vlo+vru+vro)
          vlo=vro
          vlu=vru
          xc=xc+1
        ENDDO
        u(nxp-1,0)=u(nxp-1,0)+c1*vru
        u(nxp-1,0+1)=u(nxp-1,0+1)+c2*(vru+vro)

C# south boundary handling
	IF (btype(3) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_sw_boundary(0,0)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_so_boundary(x,0)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_se_boundary(nxp-1,0)
	  ENDIF
	ENDIF
C# south preconditioning...
C# update red points on first inner line   

C# begin interpo(0,2)
        u(0,2)=u(0,2)+c1*uc(0,1)
C# end interpo
	DO x=1,nxp-2,2
C# begin interpo (x,2)
          u(x,2)=u(x,2)+c2*(uc(x/2,1)+uc(x/2+1,1))
          u(x+1,2)=u(x+1,2)+c1*uc(x/2+1,1)
C# end interpo
	  relax(x,1)
C# relax black points on south boundary if necessary
	  IF (btype(3) .EQ. 1) THEN
	    relax_so_boundary(x,0)	 
	  ENDIF
	ENDDO
C# Handling inner part of the grid:
C# update red points and black points in pairs
	DO y=2,nyp-2,2
C# begin interpo(0,y+1) & interpo(1,y+1) & interpo(nxp-1,y+1)
          u(0,y+1)=u(0,y+1)+c2*(uc(0,y/2)+uc(0,y/2+1))
          u(1,y+1)=u(1,y+1)+c3*(uc(0,y/2)+uc(0,y/2+1)+uc(1,y/2)+uc(1,y/2+1))
          u(nxp-1,y+1)=u(nxp-1,y+1)+c2*(uc(nxpc-1,y/2)+uc(nxpc-1,y/2+1))
C# end interpo
C# smoothing even grid lines
C# west boundary handling
	  IF (btype(4).EQ.1) THEN
	    relax_we_boundary(0,y)
	    relax_we_boundary(0,y-1)
	  ENDIF
C# inner nodes
	  DO x=2,nxp-2,2
C# begin interpo(x,y+1) & interpo(x+1,y+1)
            u(x,y+1)=u(x,y+1)+c2*(uc(x/2,y/2)+uc(x/2,y/2+1))
            u(x+1,y+1)=u(x+1,y+1)+c3*(uc(x/2,y/2)+uc(x/2,y/2+1)+uc(x/2+1,y/2)+uc(x/2+1,y/2+1))
C# end interpo
	    relax(x,y)
	    relax(x,y-1)
	  ENDDO
C# east boundary handling
	  IF (btype(2).EQ.1) THEN
	    relax_ea_boundary(nxp-1,y)
	    relax_ea_boundary(nxp-1,y-1)
	  ENDIF
C# smoothing odd grid lines
C# inner nodes

C# begin interpo(0,y+2)
          u(0,y+2)=u(0,y+2)+c1*uc(0,(y+2)/2)
C# end interpo
	  DO x=1,nxp-2,2
C# begin interpo(x,y+2) & interpo(x+1,y+2)
            u(x,y+2)=u(x,y+2)+c2*(uc(x/2,(y+2)/2)+uc(x/2+1,(y+2)/2))
            u(x+1,y+2)=u(x+1,y+2)+c1*uc(x/2+1,(y+2)/2)
C# end interpo
	    relax(x,y+1)
	    relax(x,y)
	  ENDDO
	ENDDO
C#  north boundary (end) handling
	IF (btype(1) .EQ. 1) THEN
	  IF (btype(4) .EQ. 1) THEN
	    relax_nw_boundary(0,nyp-1)
	    relax_we_boundary(0,nyp-2)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	    relax(x,nyp-2)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_ne_boundary(nxp-1,nyp-1)
	    relax_ea_boundary(nxp-1,nyp-2)
	  ENDIF
	  DO x=1,nxp-2,2
	    relax_no_boundary(x,nyp-1)
	  ENDDO
	ELSE
	  IF (btype(4) .EQ. 1) THEN
	    relax_we_boundary(0,nyp-2)
	  ENDIF
	  DO x=2,nxp-2,2
	    relax(x,nyp-2)
	  ENDDO
	  IF (btype(2) .EQ. 1) THEN
	    relax_ea_boundary(nxp-1,nyp-2)
	  ENDIF
	ENDIF

	DO i=2,niter
C# south boundary handling
	  IF (btype(3) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_sw_boundary(0,0)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_so_boundary(x,0)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_se_boundary(nxp-1,0)
	    ENDIF
	  ENDIF
C# south preconditioning...
C# update red points on first inner line   
	  DO x=1,nxp-2,2
	    relax(x,1)
C# relax black points on south boundary if necessary
	    IF (btype(3) .EQ. 1) THEN
	      relax_so_boundary(x,0)	 
	    ENDIF
	  ENDDO
C# Handling inner part of the grid:
C# update red points and black points in pairs
	  DO y=2,nyp-2
C# west boundary handling
	    IF ((btype(4).EQ.1) .AND. (mod(y,2) .EQ.0)) THEN
	      relax_we_boundary(0,y)
	      relax_we_boundary(0,y-1)
	    ENDIF
C# inner nodes
	    DO x=1+mod(y+1,2),nxp-2,2
	      relax(x,y)
	      relax(x,y-1)
	    ENDDO
C# east boundary handling
	    IF ((btype(2).EQ.1) .AND. (mod(y,2).EQ.0)) THEN
	      relax_ea_boundary(nxp-1,y)
	      relax_ea_boundary(nxp-1,y-1)
	    ENDIF
	  ENDDO
C#  north boundary (end) handling
	  IF (btype(1) .EQ. 1) THEN
	    IF (btype(4) .EQ. 1) THEN
	      relax_nw_boundary(0,nyp-1)
	      relax_we_boundary(0,nyp-2)
	    ENDIF
	    DO x=2,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	      relax(x,nyp-2)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_ne_boundary(nxp-1,nyp-1)
	      relax_ea_boundary(nxp-1,nyp-2)
	    ENDIF
	    DO x=1,nxp-2,2
	      relax_no_boundary(x,nyp-1)
	    ENDDO
	  ELSE
	    IF (btype(4) .EQ. 1) THEN
	      relax_we_boundary(0,nyp-2)            
            ENDIF
	    DO x=2,nxp-2,2
	      relax(x,nyp-2)
	    ENDDO
	    IF (btype(2) .EQ. 1) THEN
	      relax_ea_boundary(nxp-1,nyp-2)            
            ENDIF
	  ENDIF
	ENDDO'')
