include(general.m4)
include(relax.m4)
include(post2.m4)
include(post3.m4)
include(post4.m4)
include(postheader.m4)

C#-----------------------------------------------------------
C# define 5P solver for fused red-black Gauss-Seidel smoother
C#-----------------------------------------------------------

undefine(`RB_KERN')
define(RB_KERN,RED_BLACK_FUSED)

define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(osh5c2)

define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ogh5c2)

define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(osn5c2)

define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ogn5c2)

define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(osh5h2)

define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ogh5h2)

define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(osn5h2)

define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ogn5h2)

C#----------------------------------------------------------------
C# define 5P solver for 1D blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------

undefine(`RB_KERN')
define(RB_KERN,RED_BLACK_1DBLOCKED)

define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(osh5c3)

define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ogh5c3)

define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(osn5c3)

define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ogn5c3)

define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(osh5h3)

define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ogh5h3)

define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(osn5h3)

define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ogn5h3)

C#-----------------------------------------------------------------------
C# define 5P solver for 2D skewed blocked red-black Gauss-Seidel smoother
C#-----------------------------------------------------------------------

undefine(`RB_KERN')
define(RB_KERN,RED_BLACK_2DBLOCKED_SKEWED)

define(`relax',`relax_s_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(osh5c4)

define(`relax',`relax_g_h_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ogh5c4)

define(`relax',`relax_s_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(osn5c4)

define(`relax',`relax_g_n_5_c($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_c($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_c($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_c($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_c($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_c($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_c($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_c($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_c($1,$2)')
SUBROUTINE_DIME_RB_5P(ogn5c4)

define(`relax',`relax_s_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(osh5h4)

define(`relax',`relax_g_h_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_h_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_h_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_h_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_h_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_h_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_h_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_h_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_h_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ogh5h4)

define(`relax',`relax_s_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_s_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_s_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_s_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_s_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_s_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_s_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_s_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_s_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(osn5h4)

define(`relax',`relax_g_n_5_h($1,$2)')
define(`relax_no_boundary',`relax_no_boundary_g_n_5_h($1,$2)')
define(`relax_ne_boundary',`relax_ne_boundary_g_n_5_h($1,$2)')
define(`relax_ea_boundary',`relax_ea_boundary_g_n_5_h($1,$2)')
define(`relax_se_boundary',`relax_se_boundary_g_n_5_h($1,$2)')
define(`relax_so_boundary',`relax_so_boundary_g_n_5_h($1,$2)')
define(`relax_sw_boundary',`relax_sw_boundary_g_n_5_h($1,$2)')
define(`relax_we_boundary',`relax_we_boundary_g_n_5_h($1,$2)')
define(`relax_nw_boundary',`relax_nw_boundary_g_n_5_h($1,$2)')
SUBROUTINE_DIME_RB_5P(ogn5h4)

