#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "paddingConditions.h"
#include "paddingTools.h"
#include "alignData.h"

static void printBool(ostream &os,bool b);
static int testIntra(int argv, char **argc);
static int testInter(int argv, char **argc);
static void initArrayReferences(arrayInfo& aInfo,arrayInfo& bInfo);

int main(int argv, char **argc)
{
  cout << "======= inter =======" << endl;
  testInter(argv,argc);
  
  cout << "======= intra =======" << endl;
  testIntra(argv,argc);
  
  return 0;
  
}

static int testInter(int argv, char **argc)
{
  if(argv<5){
    cout << "Usage: <cache size> <line size> <elem size> [<dim size>]+" << endl;
    return -1;
  }

  cacheInfo cInfo(atoi(argc[1]),atoi(argc[2]));
  cout << cInfo << endl;
  
  std::vector<int> sizes;
  std::vector<int> lowerBounds;

  for(int i=4;i<argv;i++)
    {
      sizes.push_back(atoi(argc[i]));
      lowerBounds.push_back(0);
    }

  arrayInfo aInfo(atoi(argc[3]),0,sizes,lowerBounds);
  arrayInfo bInfo(atoi(argc[3]),alignData(aInfo.getSize()),sizes,lowerBounds);

  // CW: do we have 2D arrays?
  if((argv==6)) initArrayReferences(aInfo,bInfo);

  // CW: specify padding conditions...
  std::vector<interPaddingCondition> ipcList(2);
  ipcList[0]=conditionInterpad;
  ipcList[1]=conditionInterpadLite;

  arrayInfo newBInfo = getNeededInterPadding(cInfo,aInfo,bInfo,ipcList);
	
  cout << "b: old base address: " << bInfo.getBaseAddress() << endl;
  cout << "b: new base address: " << newBInfo.getBaseAddress() << endl;
  
  return 0;
}

static int testIntra(int argv, char **argc)
{
  if(argv<5){
    cout << "Usage: <cache size> <line size> <elem size> [<dim size>]+" << endl;
    return -1;
  }
	
  cacheInfo cInfo(atoi(argc[1]),atoi(argc[2]));
  cout << cInfo << endl;

  std::vector<int> sizes;
  std::vector<int> lowerBounds;

  for(int i=4;i<argv;i++)
    {
      sizes.push_back(atoi(argc[i]));
      lowerBounds.push_back(0);
    }

  arrayInfo aInfo(atoi(argc[3]),0,sizes,lowerBounds);
  arrayInfo bInfo(atoi(argc[3]),alignData(aInfo.getSize()),sizes,lowerBounds);

  // CW: do we have 2D arrays?
  if((argv==6)) initArrayReferences(aInfo,bInfo);

  // CW: specify padding conditions...
  std::vector<intraPaddingCondition> ipcList(4);
  ipcList[0]=conditionLinpad1;
  ipcList[1]=conditionLinpad2;
  ipcList[2]=conditionIntrapadLite;
  ipcList[3]=conditionIntrapad;

  // CW: perform padding...
  arrayInfo newAInfo=getNeededIntraPadding(cInfo,aInfo,ipcList);
  // CW: adjust base address
  bInfo.setBaseAddress(alignData(newAInfo.getSize()));
  arrayInfo newBInfo=getNeededIntraPadding(cInfo,bInfo,ipcList);

  cout << "a: old size: (" << aInfo.getColSize(1);
  for(int i=2;i<=aInfo.getNumberOfDimensions();i++)
    {
      cout << "," << aInfo.getColSize(i);
    }
  cout << ")" << endl;
  
  cout << "a: new size: (" << newAInfo.getColSize(1);
  for(int i=2;i<=newAInfo.getNumberOfDimensions();i++)
    {
      cout << "," << newAInfo.getColSize(i);
    }
  cout << ")" << endl;
  
  cout << "b: old size: (" << bInfo.getColSize(1);
  for(int i=2;i<=bInfo.getNumberOfDimensions();i++)
    {
      cout << "," << bInfo.getColSize(i);
    }
  cout << ")" << endl;
  
  cout << "b: new size: (" << newBInfo.getColSize(1);
  for(int i=2;i<=newBInfo.getNumberOfDimensions();i++)
    {
      cout << "," << newBInfo.getColSize(i);
    }
  cout << ")" << endl;
  
  if(conformingArrays(newAInfo,newBInfo)){
    cout << "new a and b are conforming!" << endl;
    
    // CW: specify padding conditions...
    std::vector<interPaddingCondition> ipc2List(2);
    ipc2List[0]=conditionInterpad;
    ipc2List[1]=conditionInterpadLite;
    
    arrayInfo new2BInfo = getNeededInterPadding(cInfo,newAInfo,newBInfo,ipc2List);
    cout << "b: old base address: " << newBInfo.getBaseAddress() << endl;
    cout << "b: new base address: " << new2BInfo.getBaseAddress() << endl;
    
  }
  else{
    cout << "new a and b are not conforming!" << endl;
    
    // CW: specify padding conditions...
    std::vector<interPaddingCondition> ipc2List(1);
    ipc2List[0]=conditionInterpadLite;
    
    arrayInfo new2BInfo = getNeededInterPadding(cInfo,newAInfo,newBInfo,ipc2List);
    cout << "b: old base address: " << newBInfo.getBaseAddress() << endl;
    cout << "b: new base address: " << new2BInfo.getBaseAddress() << endl;
  }
  
  return 0;
}

static void initArrayReferences(arrayInfo& aInfo,arrayInfo& bInfo)
{
  assert(aInfo.getNumberOfDimensions()==2);
  assert(bInfo.getNumberOfDimensions()==2);

  std::vector<arrayReference> aRefs;
  std::vector<arrayReference> bRefs;

  arrayReference center(2);
  arrayReference north(2);
  arrayReference south(2);
  arrayReference east(2);
  arrayReference west(2);
	
  // CW: initialize all reference constants
  for(int i=0;i<8;i++)
    {
      for(int j=0;j<8;j++)
	{
	  center[0]=-i-j; center[1]=j;  aRefs.push_back(center); bRefs.push_back(center);
	  north[0]=center(0)+1; north[1]=center(1); aRefs.push_back(north);
	  south[0]=center(0)-1; south[1]=center(1); aRefs.push_back(south);
	  east[0]=center(0); east[1]=center(1)+1; aRefs.push_back(east);
	  west[0]=center(0); west[1]=center(1)-1; aRefs.push_back(west);
	}
    }


  // add center values
  aInfo.addReferences(aRefs);
  bInfo.addReferences(bRefs);
      
}

static void printBool(ostream &os,bool b)
{
  if(b) os << "T";
  else os << "F";
}


