//-*-Mode: C++;-*-
#ifndef _paddingTools_h_
#define _paddingTool_h_

#include "arrayInfo.h"
#include "cacheInfo.h"
#include "paddingConditions.h"
#include <vector>

// CW: allowed maximum size of a padding in elements
#define PADDING_SIZE_MAX 500

// CW: if you are using padding conditions be aware of there limitations
// and restrictions described in paddingConditions.h!!!

// CW: returns new arrayInfo for array A with (eventually) padded columns
arrayInfo getNeededIntraPadding(const cacheInfo& cInfo, const arrayInfo& aInfo, const std::vector<intraPaddingCondition>& ipcList);

// CW: returns new arrayInfo for array B with (eventually) changed base address
arrayInfo getNeededInterPadding(const cacheInfo& cInfo, const arrayInfo& aInfo, const arrayInfo& bInfo, const std::vector<interPaddingCondition>& ipcList);

// CW: Test all padding conditions and return FALSE if non of it is TRUE and TRUE otherwise
bool testIntraPaddingConditions(const cacheInfo& cInfo, const arrayInfo& aInfo,const std::vector<intraPaddingCondition>& ipcList);
bool testInterPaddingConditions(const cacheInfo& cInfo, const arrayInfo& aInfo, const arrayInfo& bInfo,const std::vector<interPaddingCondition>& ipcList);

// CW: returns TRUE is the two arrays are conforming (column sizes have to be
// identical except the size of the higest dimension).
bool conformingArrays(const arrayInfo& aInfo, const arrayInfo& bInfo);

#endif
