//-*-Mode: C++;-*-
#ifndef _arrayReference_h_
#define _arrayReference_h_

#include <assert.h>
#include <vector>

// CW: the arrayReference class stores all of the constants which
// define a uniform generated array reference
class arrayReference
{
public:

  arrayReference(){};

  // CW: initialize all constants to 0
  arrayReference(std::vector<int>::size_type dimensions):refConstant(dimensions,0){};

  // CW: copy constants from another reference
  arrayReference(const arrayReference& rhs):refConstant(rhs.refConstant){};

  ~arrayReference() {};

  // CW: return constant for dimension read only
  int operator()(int elem) const {
    return refConstant[elem];
  };

  // CW: return constant read and writeable
  int& operator[](int elem){
    return refConstant[elem];
  };

  bool operator==(const arrayReference& rhs) const{
    return refConstant==rhs.refConstant;
  };

private:

  // CW: here we store the constants which define unified generated
  // references
  std::vector<int> refConstant;
};

#endif
