//-*-Mode: C++;-*-
#ifndef _arrayInfo_h_
#define _arrayInfo_h_

#include "arrayReference.h"
#include <vector>


// CW: this class stores all the data related to arrays which are
// needed for the array padding transformations.
// it stores sizes, dimension, references to array, etc.
class arrayInfo
{
public:

  arrayInfo(unsigned long elemSize,unsigned long address,const std::vector<int>& columnSizes,
	    const std::vector<int>& bounds);
  arrayInfo(const arrayInfo&);
  ~arrayInfo();
    
  arrayInfo& operator=(const arrayInfo&);
  bool operator==(const arrayInfo& rhs) const;
  bool operator!=(const arrayInfo& rhs) const;
  
  // CW: returns size of an element of the array in bytes
  unsigned long getElementSize() const { return elementSize; };
  unsigned long getNumberOfDimensions() const { return dimensions; };

  // CW: return column size: dim is dimension starting from 1
  inline int getColSize(unsigned long dim) const
  {
    assert(dim <= dimensions);
    return colSize[dim-1];
  }

  void setColSize(unsigned long dim, int size);

  // CW: get size of array in bytes
  unsigned long getSize() const;
	
  // CW: return reference to a vector which contains the constants for
  // all references to that array. The references are read only!
  const std::vector<arrayReference>& getReferences() const { return references; };
  unsigned long getNumberOfReferences() const { return references.size(); };
    
  // CW: add a new reference to the array
  void addReference(const arrayReference& newRef);
  void addReferences(const std::vector<arrayReference>& newRef);
	
  // CW: return and set base address of array:
  unsigned long getBaseAddress() const { return baseAddress; };
  void setBaseAddress(unsigned long address) { baseAddress=address; };
	
  // CW: returns lower bound of array for dimension dim
  int getLowerBound(unsigned long dim) const;

private:

  unsigned long baseAddress;
  
  unsigned long elementSize; // CW: size of one element of the array
  unsigned long dimensions; // CW: dimension of array
  
  std::vector<int> colSize;    // CW: size of each column
  std::vector<int> lowerBound; // CW: lowerBounds of the array
  
  // CW: references hve to be uniformy generated
  // Hence, we can store them by remembering the constants
  std::vector<arrayReference> references;

};

#endif
