      DIME_REAL function dpAbs(n)
      IMPLICIT NONE
      DIME_REAL n
      IF (n.ge.0.0) THEN
         dpAbs=n
      ELSE
         dpAbs=-n
      ENDIF
      END

      DIME_REAL function lnmn5(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)

      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(5)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ea,so,we,norm,res
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ea=coeff(3)
      so=coeff(4)
      we=coeff(5)

      norm=0d0

      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,0)+ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=f(x,0)+ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,0)+ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF


      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=f(0,y)+ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=f(x,y)+ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=f(nxp-1,y)+ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+(we+ea)*u(nxp-1-1,y)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,nyp-1)+ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=f(x,nyp-1)+ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+we*u(x-1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,nyp-1)+ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF
      
      lnmn5=sqrt(norm)

      END


      DIME_REAL function mnmn5(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)

      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(5)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ea,so,we,norm,res
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ea=coeff(3)
      so=coeff(4)
      we=coeff(5)

      norm=0d0

      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,0)+ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=f(x,0)+ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,0)+ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF


      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=f(0,y)+ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=f(x,y)+ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=f(nxp-1,y)+ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+(we+ea)*u(nxp-1-1,y)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,nyp-1)+ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=f(x,nyp-1)+ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+we*u(x-1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,nyp-1)+ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF
      
      mnmn5=norm

      END


      DIME_REAL function lnmn9(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)
      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(9)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ne,ea,se,so,sw,we,nw,res,norm
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ne=coeff(3)
      ea=coeff(4)
      se=coeff(5)
      so=coeff(6)
      sw=coeff(7)
      we=coeff(8)
      nw=coeff(9)

      norm=0d0
	
      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,0)+ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=f(x,0)+ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)+(ne+se)*u(x+1,0+1)+(nw+sw)*u(x-1,0+1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,0)+ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF

      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=f(0,y)+ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)+
     &       (ne+nw)*u(0+1,y+1)+(se+sw)*u(0+1,y-1)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=f(x,y)+ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)+
     &       ne*u(x+1,y+1)+se*u(x+1,y-1)+nw*u(x-1,y+1)+sw*u(x-1,y-1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=f(nxp-1,y)+ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+
     &       (we+ea)*u(nxp-1-1,y)+(nw+ne)*u(nxp-1-1,y+1)+(sw+se)*u(nxp-1-1,y-1)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,nyp-1)+ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=f(x,nyp-1)+ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+
     &       we*u(x-1,nyp-1)+(se+ne)*u(x+1,nyp-1-1)+(sw+nw)*u(x-1,nyp-1-1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,nyp-1)+ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF

      lnmn9=sqrt(norm)

      END

      DIME_REAL function mnmn9(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)
      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(9)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ne,ea,se,so,sw,we,nw,res,norm
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ne=coeff(3)
      ea=coeff(4)
      se=coeff(5)
      so=coeff(6)
      sw=coeff(7)
      we=coeff(8)
      nw=coeff(9)

      norm=0d0
	
      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,0)+ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=f(x,0)+ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)+(ne+se)*u(x+1,0+1)+(nw+sw)*u(x-1,0+1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,0)+ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF

      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=f(0,y)+ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)+(ne+nw)*u(0+1,y+1)+(se+sw)*u(0+1,y-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=f(x,y)+ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)+
     &       ne*u(x+1,y+1)+se*u(x+1,y-1)+nw*u(x-1,y+1)+sw*u(x-1,y-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=f(nxp-1,y)+ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+
     &       (we+ea)*u(nxp-1-1,y)+(nw+ne)*u(nxp-1-1,y+1)+(sw+se)*u(nxp-1-1,y-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=f(0,nyp-1)+ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=f(x,nyp-1)+ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+
     &       we*u(x-1,nyp-1)+(se+ne)*u(x+1,nyp-1-1)+(sw+nw)*u(x-1,nyp-1-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=f(nxp-1,nyp-1)+ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF

      mnmn9=norm

      END

      DIME_REAL function lnmh5(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)

      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(5)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ea,so,we,norm,res
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ea=coeff(3)
      so=coeff(4)
      we=coeff(5)

      norm=0d0

      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF


      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+(we+ea)*u(nxp-1-1,y)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+we*u(x-1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF
      
      lnmh5=sqrt(norm)

      END


      DIME_REAL function mnmh5(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)

      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(5)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ea,so,we,norm,res
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ea=coeff(3)
      so=coeff(4)
      we=coeff(5)

      norm=0d0

      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF


      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+(we+ea)*u(nxp-1-1,y)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+we*u(x-1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF
      
      mnmh5=norm

      END


      DIME_REAL function lnmh9(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)
      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(9)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ne,ea,se,so,sw,we,nw,res,norm
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ne=coeff(3)
      ea=coeff(4)
      se=coeff(5)
      so=coeff(6)
      sw=coeff(7)
      we=coeff(8)
      nw=coeff(9)

      norm=0d0
	
      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)+(ne+se)*u(x+1,0+1)+(nw+sw)*u(x-1,0+1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF

      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)+
     &       (ne+nw)*u(0+1,y+1)+(se+sw)*u(0+1,y-1)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)+
     &       ne*u(x+1,y+1)+se*u(x+1,y-1)+nw*u(x-1,y+1)+sw*u(x-1,y-1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+
     &       (we+ea)*u(nxp-1-1,y)+(nw+ne)*u(nxp-1-1,y+1)+(sw+se)*u(nxp-1-1,y-1)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+
     &       we*u(x-1,nyp-1)+(se+ne)*u(x+1,nyp-1-1)+(sw+nw)*u(x-1,nyp-1-1)
            norm=norm+res*res*hx*hy
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            norm=norm+res*res*hx*hy
         ENDIF
      ENDIF

      lnmh9=sqrt(norm)

      END

      DIME_REAL function mnmh9(nxp,nyp,u,padu,f,padf,coeff,btype,omega,hx,hy)
      IMPLICIT NONE
      DIME_REAL dpAbs
      INTEGER nxp,nyp
      DIME_REAL coeff(9)
      INTEGER btype(4)
      INTEGER padu,padf
      DIME_REAL u(0:nxp+padu-1,0:nyp-1)
      DIME_REAL f(0:nxp+padf-1,0:nyp-1)
      DIME_REAL omega
      DIME_REAL hx
      DIME_REAL hy

      DIME_REAL ce,no,ne,ea,se,so,sw,we,nw,res,norm
      INTEGER x,y

      ce=-omega
      no=coeff(2)
      ne=coeff(3)
      ea=coeff(4)
      se=coeff(5)
      so=coeff(6)
      sw=coeff(7)
      we=coeff(8)
      nw=coeff(9)

      norm=0d0
	
      IF (btype(3) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,0)+(no+so)*u(0,0+1)+(ea+we)*u(0+1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,0)+(no+so)*u(x,0+1)+ea*u(x+1,0)+we*u(x-1,0)+(ne+se)*u(x+1,0+1)+(nw+sw)*u(x-1,0+1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,0)+(no+so)*u(nxp-1,0+1)+(we+ea)*u(nxp-1-1,0)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF

      DO y=1,nyp-2
         IF (btype(4).EQ.1) THEN
            res=ce*u(0,y)+no*u(0,y+1)+so*u(0,y-1)+(ea+we)*u(0+1,y)+(ne+nw)*u(0+1,y+1)+(se+sw)*u(0+1,y-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,y)+no*u(x,y+1)+so*u(x,y-1)+ea*u(x+1,y)+we*u(x-1,y)+
     &       ne*u(x+1,y+1)+se*u(x+1,y-1)+nw*u(x-1,y+1)+sw*u(x-1,y-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2).EQ.1) THEN
            res=ce*u(nxp-1,y)+no*u(nxp-1,y+1)+so*u(nxp-1,y-1)+
     &       (we+ea)*u(nxp-1-1,y)+(nw+ne)*u(nxp-1-1,y+1)+(sw+se)*u(nxp-1-1,y-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDDO

      IF (btype(1) .EQ. 1) THEN
         IF (btype(4) .EQ. 1) THEN
            res=ce*u(0,nyp-1)+(so+no)*u(0,nyp-1-1)+(ea+we)*u(0+1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
         DO x=1,nxp-2
            res=ce*u(x,nyp-1)+(so+no)*u(x,nyp-1-1)+ea*u(x+1,nyp-1)+
     &       we*u(x-1,nyp-1)+(se+ne)*u(x+1,nyp-1-1)+(sw+nw)*u(x-1,nyp-1-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDDO
         IF (btype(2) .EQ. 1) THEN
            res=ce*u(nxp-1,nyp-1)+(so+no)*u(nxp-1,nyp-1-1)+(we+ea)*u(nxp-1-1,nyp-1)
            res=dpAbs(res)
            IF(res.GT.norm) norm=res
         ENDIF
      ENDIF

      mnmh9=norm

      END
