include(general.m4)

      subroutine interp(nxp,nyp,u,padu,nxpc,nypc,uc,paduc,btype)
      IMPLICIT NONE
      INTEGER nxp,nyp,padu
      INTEGER nxpc,nypc,paduc
      DIME_REAL u(0:nxp-1+padu,0:nyp-1)
      DIME_REAL uc(0:nxpc-1+paduc,0:nypc-1)
      INTEGER btype(4)

      DIME_REAL c1,c2,c3
      PARAMETER (c1=1.0,c2=0.5,c3=0.25)

      INTEGER x,xc,y,yc

      DIME_REAL vlu,vru,vlo,vro

      yc=0
      DO y=0,nyp-3,2
        xc=0
        vlu=uc(xc,yc)
        vlo=uc(xc,yc+1)
        DO x=0,nxp-3,2
          vru=uc(xc+1,yc)
          vro=uc(xc+1,yc+1)
          u(x,y)=u(x,y)+c1*vlu
          u(x,y+1)=u(x,y+1)+c2*(vlu+vlo)
          u(x+1,y)=u(x+1,y)+c2*(vlu+vru)
          u(x+1,y+1)=u(x+1,y+1)+c3*(vlu+vlo+vru+vro)
          vlo=vro
          vlu=vru
          xc=xc+1
        ENDDO
        u(nxp-1,y)=u(nxp-1,y)+c1*vru
        u(nxp-1,y+1)=u(nxp-1,y+1)+c2*(vru+vro)
        yc=yc+1
      ENDDO
      IF (btype(1).EQ.1) THEN
        xc=0
        vlo=uc(xc,nypc-1)
        DO x=0,nxp-3,2
          vro=uc(xc+1,nypc-1)
          u(x,nyp-1)=u(x,nyp-1)+c1*vlo
          u(x+1,nyp-1)=u(x+1,nyp-1)+c2*(vlo+vro)
          vlo=vro
          xc=xc+1
        ENDDO
        u(nxp-1,nyp-1)=u(nxp-1,nyp-1)+c1*vro
      ENDIF
      END
        
C      vlo=uc(1,1)
C      u(1,1)=u(1,1)+c3*vlo
C      DO x=2,nxp-5,2
C        xc=x/2
C        u(x,1)=u(x,1)+c2*vlo
C        vro=uc(xc+1,1)
C        u(x+1,1)=u(x+1,y)+c3*(vlo+vro)
C        vlo=vro
C      ENDDO
C      u(nxp-3,1)=u(nxp-3,1)+c2*vlo
C      u(nxp-2,y)=u(nxp-2,1)+c3*vlo
CC handling 2 grid lines together in the inner part of the grid
C      DO y=2,nyp-5,2
C        yc=y/2
C        vlu=uc(1,yc)
C        u(1,y)=u(1,y)+c2*vlu
C        vlo=uc(1,yc+1)
C        u(1,y+1)=u(1,y+1)+c3*(vlu+vlo)
C        DO x=2,nxp-5,2
C          xc=x/2
C          u(x,y)=u(x,y)+c1*vlu
C          u(x,y+1)=u(x,y+1)+c2*(vlo+vlu)
C          vru=uc(xc+1,yc)
C          u(x+1,y)=u(x+1,y)+c2*(vlu+vru)
C          vro=uc(xc+1,yc+1)
C          u(x+1,y+1)=u(x+1,y+1)+c3*(vlo+vro+vru+vlu)
C          vlo=vro
C          vlu=vru
C        ENDDO
C        u(nxp-3,y)=u(nxp-3,y)+c1*vlu
C        u(nxp-3,y+1)=u(nxp-3,y)+c2*(vlu+vlo)
C        u(nxp-2,y)=u(nxp-2,y)+c2*vlu
C        u(nxp-2,y+1)=u(nxp-2,y+1)+c3*(vlu+vlo)
C      ENDDO
C handling uppermost two grid lines
C      vlu=uc(1,nypc-2)
C      u(1,nyp-3)=u(1,nyp-3)+c2*vlu
C      u(1,nyp-2)=u(1,nyp-2)+c3*vlu
C      DO x=2,nxp-5,2
C        xc=x/2
C        u(x,nyp-3)=u(x,nyp-3)+c1*vlu
C        u(x,nyp-2)=u(x,nyp-2)+c2*vlu
C        vru=uc(xc+1,nypc-2)
C        u(x+1,nyp-3)=u(x+1,nyp-3)+c2*(vlu+vru)
C       u(x+1,nyp-2)=u(x+1,nyp-2)+c3*(vlu+vru)
C        vlu=vru
C      ENDDO
C      u(nxp-3,nyp-2)=u(nxp-3,nyp-2)+c2*vlu
C      u(nxp-2,nyp-2)=u(nxp-2,nyp-2)+c3*vlu
C      END

C boundary handling can be done seperately in advance if
C we assume that boundary values are only interpolated to other
C boundary values. furthermore, if we have a dirichlet boundary
C the solution values of the boundary off the coarser grid are 0
C this is used to remove some IFs and to simplify the code
C      IF (btype(3).EQ.1) THEN
C        vlo=uc(0,0)
C        DO x=0,nxp-3,2
C          xc=x/2
C          u(x,0)=u(x,0)+b1*vlo
C          vro=uc(xc+1,0)
C          u(x+1,0)=u(x+1,0)+b2*(vlo+vro)
C          vlo=vro
C        ENDDO
C        u(nxp-1,0)=u(nxp-1,0)+b1*vlo
C      ENDIF
C      IF (btype(4).EQ.1) THEN
C        vlu=uc(0,0)
C        DO y=1,nyp-2,2 THEN
C          yc=(y+1)/2
C          vlo=uc(0,yc)
C          u(0,y)=u(0,y)+b2*(vlu*vlo)
C          u(0,y+1)=u(0,y+1)+b1*vlo
C          vlu=vlo
C        ENDDO
C      ENDIF
C      IF (btype(2).EQ.1) THEN
C        vlu=uc(nxpc-1,0)
C        DO y=1,nyp-2,2 THEN
C          yc=(y+1)/2
C          vlo=uc(nxpc-1,yc)
C          u(nxp-1,y)=u(nxp-1,y)+b2*(vlu*vlo)
C          u(nxp-1,y+1)=u(nxp-1,y+1)+b1*vlo
C          vlu=vlo
C        ENDDO
C      ENDIF
C      IF (btype(1).EQ.1) THEN
C        vlo=uc(0,nyp-1)
C        DO x=1,nxp-4,2
C          u(x,nyp-1)=u(x,nyp-1)+b2*(vlo+vro)
C          u(x+1,nyp-1)=u(x+1,nyp-1)+b1*vro
C          vlo=vro
C        ENDDO
C        u(nxp-2,nyp-1)=u(nxp-2,nyp-1)+b2*(vlo*uc(nxpc-1,nypc-1))
C      ENDIF
