// Definitions of data types for the DiMEPACK library:
// ---------------------------------------------------

#ifndef _DIME_TYPES_H_
#define _DIME_TYPES_H_

/* Type of boundary condition:
 */
typedef enum
{
  DIRICHLET,
  NEUMANN
} tBoundary;

/* Macros for the numbering of the boundaries:
 */
#define dpNORTH 0
#define dpEAST 1
#define dpSOUTH 2
#define dpWEST 3

/* Type of restriction operator:
 * Since we use a red/black ordering of the unknowns half weighting
 * is equivalent to half injection
 */
typedef enum
{
  HW, // Half weighting
  FW  // Full weighting
} tRestrict;

typedef enum 
{
  L2, // L2 norm
  MAX // Maximum norm
} tNorm;

#endif
