#ifndef _DPMGDATA_H_
#define _DPMGDATA_H_

#include "dpGrid2d.h"
#include "dpTypes.h"


class dpMgData
{
 public:
  dpMgData(int nLevels, int nCoeff, dpGrid2d *u, dpGrid2d *fIn,
	   DIME_REAL *matCoeff, tBoundary *bTypes, bool isInitialized, 
	   DIME_REAL **bVals, DIME_REAL omega, bool isFmg,
           const bool fixCGSolution);
  ~dpMgData();

  int *xDims; // Numbers of grid points in dimension x
  int *yDims; // Numbers of grid points in dimension y
  int *uPads; // Paddings for solution arrays
  int *fPads; // Paddings for rhs arrays
  DIME_REAL *hx; // Mesh widths in dimension x
  DIME_REAL *hy; // Mesh widths in dimension y
  DIME_REAL *coeff; // Coefficients to be passed to the smoothing procedures
  int maxLevel; // Index of highest level
  bool isHom; // Flag specifying if problem is homogeneous
  bool isIdCoeff; // Flag specifying if the non-center coefficients are equal
  DIME_REAL **uGrids; // Solution vectors
  DIME_REAL **fGrids; // Rhs's
  dpGrid2d *fLoc; // Copy of the rhs
  int nCoeff; // Number of entries per matrix row
  DIME_REAL *matCoeff; // Matrix coefficients

 private:
  dpMgData(const dpMgData&);
  void getCoeffConst(DIME_REAL omega);
  void prepRhsConst(DIME_REAL *f, int nxp, int nyp, int fpad,
		    DIME_REAL omega, tBoundary *btypes, DIME_REAL **bvals, DIME_REAL hx,
		    DIME_REAL hy);
  void insertDBCConst(DIME_REAL *u, int nxp, int nyp, int upad, tBoundary *btypes,
		      DIME_REAL **bvals);
};

#endif
