#ifndef _GRID2D_H_
#define _GRID2D_H_

#include "dpTypes.h"
#include <iostream.h>
#include <string.h>
#include <assert.h>

class dpGrid2d;

ostream& operator<<(const dpGrid2d& grid,ostream& os);

class dpGrid2d
{
 public:
  dpGrid2d(int, int, DIME_REAL, DIME_REAL);
  ~dpGrid2d();

  dpGrid2d& operator=(const dpGrid2d& rhs);

  inline int getdimx() const { return dimx; };
  inline int getdimy() const { return dimy; };
  inline DIME_REAL gethx() const { return hx; };
  inline DIME_REAL gethy() const { return hy; };  
  inline int getpad() const { return pad; };  
  inline DIME_REAL* getmem() { return mem; };

  inline void initzero(){
    memset(mem,0,(dimx+pad)*dimy*sizeof(DIME_REAL));
  };

  inline DIME_REAL& setval(int x,int y){
    assert(x>=0 && x<dimx);
    assert(y>=0 && y<dimy);
    return mem[y*(dimx+pad)+x];
  };

  inline DIME_REAL getval(int x,int y) const {
    assert(x>=0 && x<dimx);
    assert(y>=0 && y<dimy);
    return mem[y*(dimx+pad)+x];
  };

 private:
  int dimx, dimy;
  DIME_REAL hx, hy;
  int pad;
  DIME_REAL *mem;

};

#endif
