#include "dpGrid2d.h"

#include <assert.h>
#include <iostream.h>
#include <string.h>
#include <paddingTools.h>
#include "dpApplyPadding.h"

dpGrid2d::dpGrid2d(int xdim, int ydim, DIME_REAL xh, DIME_REAL yh)
{
  dimx= xdim;
  dimy= ydim;
  hx= xh;
  hy= yh;

  pad=dpCalcPaddingSize(xdim,ydim);

  mem=new DIME_REAL[(dimx+pad)*dimy];
  assert(mem!=NULL);
}

dpGrid2d::~dpGrid2d()
{
  delete[] mem;
}

dpGrid2d& dpGrid2d::operator=(const dpGrid2d& rhs)
{
  if(this==(&rhs)) return (*this);
  else {
    if((dimx+pad)*dimy<(rhs.dimx+rhs.pad)*rhs.dimy) {
      assert(mem!=NULL);
      delete [] mem;
      mem=new DIME_REAL[(rhs.dimx+rhs.pad)*rhs.dimy];
      assert(mem!=NULL);
    }

    dimx=rhs.dimx;
    dimy=rhs.dimy;
    pad=rhs.pad;
    hx=rhs.hx;
    hy=rhs.hy;

    assert(rhs.mem!=NULL);
    memcpy(mem,rhs.mem,(dimx+pad)*dimy*sizeof(DIME_REAL));

  }
  return (*this);
}

ostream& operator<<(const dpGrid2d& grid,ostream& os)
{
  for(int x=0; x<grid.getdimx() ; x++)
  {
    for(int y=0; y<grid.getdimy() ; y++)
    {
      os << x << " " << y << " " << grid.getval(x,y) << endl;
    }

    os << endl;
  }

  return os;
}
