// Global variables for the modules belonging to the direct solution
// of the coarsest problem

#ifndef _DIME_DIRECT_SOLVE_GLOBALS_H_
#define _DIME_DIRECT_SOLVE_GLOBALS_H_

extern bool useCholesky; // Flag specifying if Cholesky's method is applied.
extern DIME_REAL *Ac; // Matrix for the coarsest system
extern int kl; // Number of subdiagonals (= number of superdiagonals)
extern int ldab; // Leading dimension of matrix array Ac
extern int neqs; // Number of equations in coarsest system
extern int *ipiv; // Pivot indices
extern DIME_REAL *w; // Rhs resp. solution vector for the coarsest system
extern int *eqmap; // To map the equation to the index of the array
extern bool fixCorner; // Flag indicating if we have to fix the SW corner value on the coarsest grid

#endif
