// Header file containing the prototypes of the functions that
// are exported by the modules dpDirectSolve.C,
// dpBuild5pCMatrix.C, dpBuild9pCMatrix.C

#ifndef _DIRECT_SOLVE_H_
#define _DIRECT_SOLVE_H_

#include "dpTypes.h"

void dpCheckProblem(int, DIME_REAL *, tBoundary *);
int dpGetNumEqs(int, int, tBoundary *);
void dpUseCholesky(int, DIME_REAL *, tBoundary *);
void dpBuild5pCMatrix(int, int, DIME_REAL *, DIME_REAL, tBoundary *, const bool);
void dpBuild9pCMatrix(int, int, DIME_REAL *, DIME_REAL, tBoundary *, const bool);
void dpDirectSolve(DIME_REAL *, DIME_REAL *, int, int, tBoundary *);
void dpDirectSolveCleanup(void);

#endif
